package com.elitesland.pur.provider;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.pur.Application;
import com.elitesland.pur.dto.gr.*;
import com.elitesland.pur.dto.gr.PurGrRpcDTO;
import com.elitesland.pur.dto.gr.PurGrRpcSaveDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 采购收货单RPC接口
 *
 * @author chaofeng.xia
 * @date 2023/10/8 9:35
 */
@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + PurGrProvider.PATH)
public interface PurGrProvider {
    String PATH = "/purGr";

    /**
     * 跨公司交易，越库生单
     * @param purGrRpcSaveDTO 入库单信息
     * @return 入库单id
     */
    @PostMapping("/createByCrossCompany")
    ApiResult<Long> createByCrossCompany(@RequestBody PurGrRpcSaveDTO purGrRpcSaveDTO);

    /**
     * 确认采购收货单
     * @param purGrRpcSaveDTO 入库单信息
     * @return 入库单id
     */
    @PostMapping("/confirmPurGr")
    ApiResult<Long> confirmPurGr(@RequestBody PurGrRpcSaveDTO purGrRpcSaveDTO);

    @GetMapping("/findById")
    ApiResult<PurGrRpcDTO> findById(@RequestParam("id") Long id);

    /**
     * 采购收货单部分收货接口
     *
     * @param purGrConfirmRpcDTO 采购收货单信息
     * @return 采购收货单ID
     */
    @PostMapping("/partConfirmPurGr")
    ApiResult<Long> partConfirmPurGr(PurGrConfirmRpcDTO purGrConfirmRpcDTO);

    @GetMapping("/needQt")
    ApiResult<Boolean> needQt(@RequestParam("id") Long id);
}
