package com.elitesland.pur.dto.po;

import com.elitesland.pur.base.BaseModelVO;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 采购订单明细(PurPoD)实体类
 * </p>
 *
 * @author tina.he
 * @since 2020-07-21 10:05:06
 */
@Data
@ApiModel(value = "pur_po_d", description = "采购订单明细")
public class PurPoDDTO extends BaseModelVO implements Serializable {
    private static final long serialVersionUID = -80930439806269356L;
    /**
     * 主表ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("主表ID")
    private Long masId;

    @ApiModelProperty("关联单据编号")
    String poNo;

    /**
     * 采购订单编号
     */
    @ApiModelProperty("采购订单编号")
    private String poCode;

    @ApiModelProperty("采购订单ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long poId;

    /**
     * 公司ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("公司ID")
    private Long ouId;
    /**
     * BUID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("BUID")
    private Long buId;
    /**
     * 单据编号
     */
    @ApiModelProperty("单据编号")
    private String docNo;

    /**
     * 行号
     */
    @ApiModelProperty("行号")
    private Integer lineNo;
    /**
     * 收货仓库ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("收货仓库ID")
    private Long whId;
    /**
     * 功能区 [UDC]INV:FUNC_TYPE
     */
    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    @SysCode(sys="yst-inv",mod = "FUNC_TYPE")
    private String deter2;
    private String deter2Name;
    /**
     * 供应商ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("供应商ID")
    private Long suppId;
    /**
     * 品项ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("品项ID")
    private Long itemId;
    /**
     * 品项编号
     */
    @ApiModelProperty("品项编号")
    private String itemCode;
    /**
     * 品项名称
     */
    @ApiModelProperty("品项名称")
    private String itemName;
    /**
     * 品项规格
     */
    @ApiModelProperty("品项规格")
    private String itemSpec;

    /**
     * 条码
     */
    @ApiModelProperty("条码")
    private String barcode;
    /**
     * 数量
     */
    @ApiModelProperty("数量")
    private Double qty;
    /**
     * 单位
     */
    @ApiModelProperty("单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;
    /**
     * 不含税价格
     */
    @ApiModelProperty("不含税价格")
    private BigDecimal netPrice;
    /**
     * 含税单价
     */
    @ApiModelProperty("含税单价")
    private BigDecimal price;
    /**
     * 未税单价(外币）
     */
    @ApiModelProperty("未税单价(外币）")
    private BigDecimal currNetPrice;
    /**
     * 含税单价(外币)
     */
    @ApiModelProperty("含税单价(外币)")
    private BigDecimal currPrice;
    /**
     * 价格本价格
     */
    @ApiModelProperty("价格本价格")
    private BigDecimal pbPrice;
    /**
     * 价格本币种
     */
    @ApiModelProperty("价格本币种")
    private String pbCurr;
    private String pbCurrName;
    /**
     * 价格本单位
     */
    @ApiModelProperty("价格本单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String pbUom;
    private String pbUomName;
    /**
     * 商品税类型
     */
    @ApiModelProperty("商品税类型")
    private String itemTaxType;
    /**
     * 税率编号
     */
    @ApiModelProperty("税率编号")
    private String taxRateNo;
    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private Double taxRate;
    /**
     * 税额
     */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
    /**
     * 含税金额
     */
    @ApiModelProperty("含税金额")
    private BigDecimal amt;
    /**
     * 不含税金额
     */
    @ApiModelProperty("不含税金额")
    private BigDecimal netAmt;
    /**
     * 外币含税金额
     */
    @ApiModelProperty("外币含税金额")
    private BigDecimal currAmt;
    /**
     * 外币不含税金额
     */
    @ApiModelProperty("外币不含税金额")
    BigDecimal currNetAmt;
    /**
     * 本币币种
     */
    @ApiModelProperty("本币币种")
    private String homeCurr;
    /**
     * 币种
     */
    @ApiModelProperty("币种")
    private String currCode;
    private String currName;
    /**
     * 汇率
     */
    @ApiModelProperty("汇率")
    private Double currRate;
    /**
     * 通知发货数量
     */
    @ApiModelProperty("通知发货数量")
    private BigDecimal shipmentQty;
    /**
     * 已出库数量
     */
    @ApiModelProperty("已出库数量")
    private Double shippedQty;
    /**
     * 已收数量
     */
    @ApiModelProperty("已收数量")
    private Double acceptQty;

    @ApiModelProperty("拒收数量")
    private BigDecimal rejectedQty;

    /**
     * 收货单位
     */
    @ApiModelProperty("收货单位")
    private String acceptUom;
    /**
     * 收货日期
     */
    @ApiModelProperty("收货日期")
    private LocalDateTime acceptDate;
    /**
     * 已退数量
     */
    @ApiModelProperty("已退数量")
    private Double returnedQty;
    /**
     * 实际未发货数量
     */
    @ApiModelProperty("实际未发数量")
    private Double acUnshipQty;
    /**
     * 要求交期
     */
    @ApiModelProperty("要求交期")
    private LocalDateTime demandDate;
    /**
     * 收货允差
     */
    @ApiModelProperty("收货允差")
    private Double recvTolerance;

    /**
     * 已取消数量
     */
    @ApiModelProperty("已取消数量")
    private Double canceledQty;
    /**
     * 关联单据类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据类别 [UDC]COM:DOC_CLS")
    @SysCode(sys = "yst-supp",mod = "DOC_CLS")
    private String relateDocCls;
    @ApiModelProperty("关联单据类别名称")
    private String relateDocClsName;
    /**
     * 关联单据类型
     */
    @ApiModelProperty("关联单据类型")
    private String relateDocType;
    /**
     * 关联单据ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("关联单据ID")
    private Long relateDocId;
    /**
     * 关联单据编号
     */
    @ApiModelProperty("关联单据编号")
    private String relateDocNo;
    /**
     * 关联单据明细ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("关联单据明细ID")
    private Long relateDocDid;
    /**
     * 关联单据行号
     */
    @ApiModelProperty("关联单据行号")
    private Double relateDocLineno;
    /**
     * 关联单据2类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据2类别 [UDC]COM:DOC_CLS")
    @SysCode(sys = "yst-supp",mod = "DOC_CLS")
    private String relateDoc2Cls;
    @ApiModelProperty("关联单据2类别名称")
    private String relateDoc2ClsName;
    /**
     * 关联单据2类型
     */
    @ApiModelProperty("关联单据2类型")
    private String relateDoc2Type;
    /**
     * 关联单据2ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("关联单据2ID")
    private Long relateDoc2Id;
    /**
     * 关联单据2编号
     */
    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;
    /**
     * 关联单据2明细ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("关联单据2明细ID")
    private Long relateDoc2Did;
    /**
     * 关联单据2行号
     */
    @ApiModelProperty("关联单据2行号")
    private Double relateDoc2Lineno;
    /**
     * ES2
     */
    @ApiModelProperty("ES2")
    private String es2;

    @ApiModelProperty("品牌code")
    private String dbrand;
    private String dbrandName;

    @ApiModelProperty("保质期天数")
    @JsonSerialize(using = ToStringSerializer.class)
    private Integer storeExpireDays;

    @ApiModelProperty("订单日期")
    private LocalDateTime docTime;

    @ApiModelProperty("请款人员工ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long docEmpId;
    String docEmpName;

    @ApiModelProperty("来源单据类别[UDC]COM:DOC_CLS]")
    String rootDocCls;

    @ApiModelProperty("来源单据类型")
    String rootDocType;

    @ApiModelProperty("来源单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long rootDocId;

    @ApiModelProperty("来源单据编号")
    String rootDocNo;

    @ApiModelProperty("来源单据明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long rootDocDid;

    @ApiModelProperty("来源单据行号")
    Integer rootDocLineNo;


    /**
     * 发运联系人
     */
    @ApiModelProperty("发运联系人")
    private String shipmentContactName;

    /**
     * 发运联系电话
     */
    @ApiModelProperty("发运联系电话")
    private String shipmentContactTel;


    /**
     * 运输方式 [UDC]COM:TP_TYPE
     */
    @ApiModelProperty("运输方式 [UDC]COM:TP_TYPE")
    @SysCode(sys = "yst-supp",mod = "TP_TYPE")
    private String transType;
    private String transTypeName;



    @ApiModelProperty("采购场景ID")
    private Long sceneTypeId;

    @ApiModelProperty("采购场景编码")
    private String sceneTypeCode;

    @ApiModelProperty("收货地址类型[PUR:ADDR_TYPE]")
    @SysCode(sys = "yst-purc", mod = "ADDR_TYPE")
    private String recvAddrType;
    @ApiModelProperty("收货地址类型名称")
    private String recvAddrTypeName;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("收货单位ID")
    private Long acceptOuId;
    @ApiModelProperty("收货单位名称")
    private String acceptOuName;
    @ApiModelProperty("收货单位编码")
    private String acceptOuCode;

    @ApiModelProperty("仓库编号")
    private String whCode;
    @ApiModelProperty("仓库类型")
    private String whType;
    @ApiModelProperty("仓库名称")
    private String whName;
    @ApiModelProperty("国家")
    @SysCode(sys = "yst-supp", mod = "COUNTRY")
    private String country;
    private String countryName;
    @ApiModelProperty("省编码")
    private String province;
    private String provinceName;
    @ApiModelProperty("市编码")
    private String city;
    private String cityName;
    @ApiModelProperty("区编码")
    private String county;
    private String countyName;

    @ApiModelProperty("收货地址")
    private String recvAddr;
    @ApiModelProperty("收货联系人姓名")
    private String recvContactName;
    @ApiModelProperty("收货联系人电话")
    private String recvContactPhone;
    @ApiModelProperty("退货申请数量")
    private BigDecimal rpoReturnQty;

    @ApiModelProperty("销售含税金额")
    private BigDecimal lastPathSaleAmt;

    @ApiModelProperty("销售含税单价")
    private BigDecimal lastPathSalePrice;
}
