package com.elitesland.pur.provider;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.pur.Application;
import com.elitesland.pur.dto.supp.PurSuppSubItemRpcParam;
import com.elitesland.pur.dto.supp.PurSuppSubItemRpcVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;

import java.util.List;

@FeignClient(name = Application.NAME, path = Application.PATH + PurSuppSubItemProvider.PATH)
@Validated
public interface PurSuppSubItemProvider {

    String PATH = "/purSuppSubItem";


    /**
     * 查询合格供应商清单
     *
     * @param param
     * @return
     */
    @PostMapping("/querySubItemList")
    public ApiResult<List<PurSuppSubItemRpcVO>> querySubItemList(PurSuppSubItemRpcParam param);
}
