package com.elitesland.pur.dto.gr;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;


/**
 * 采购收货单确认收货主表
 *
 * @author chaofeng.xia
 * @date 2024/5/7 18:10
 */
@Data
@ApiModel(value = "pur_gr", description = "采购收货单确认收货主表")
public class PurGrConfirmRpcDTO implements Serializable {

    private static final long serialVersionUID = 2256804315999590305L;

    /**
     * 采购收货单id
     */
    @ApiModelProperty("采购收货单id")
    private Long id;

    /**
     * 是否收货完成
     */
    @ApiModelProperty("是否收货完成")
    private Boolean completeFlag;

    /**
     * 收货日期
     */
    @ApiModelProperty("收货日期")
    private LocalDateTime recvDate;

    /**
     * 收货单明细
     */
    @ApiModelProperty(value = "收货单明细")
    private List<PurGrdConfirmRpcDTO> purGrdConfirmRpcDTOList;
}
