package com.elitesland.pur.dto.po;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 采购订单(PurPo)实体类
 *
 * @author liuqi
 * @since 2020-07-21 10:04:45
 */
@Getter
@Setter
@ApiModel(value = "pur_po", description = "采购订单")
public class PurPoCreateDTO extends CustomFieldBaseModelVo implements Serializable {
    private static final long serialVersionUID = -34281089348927283L;

    @ApiModelProperty("单据编号")
    private String docNo;

    @ApiModelProperty("单据类型 [UDC]PUR:PO_TYPE")
    @SysCode(sys = "yst-purc", mod = "PO_TYPE")
    private String docType;
    @ApiModelProperty("单据类型名称")
    private String docTypeName;

    @ApiModelProperty("公司ID")
    private Long ouId;
    @ApiModelProperty("公司编码")
    private String ouCode;
    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("组织ID")
    private Long buId;
    @ApiModelProperty("组织编码")
    private String buCode;
    @ApiModelProperty("组织名称")
    private String buName;

    @ApiModelProperty("公司地址")
    private String ouAddress;
    @ApiModelProperty("公司电话")
    private String ouPhone;
    @ApiModelProperty("公司传真")
    private String ouFax;

    @ApiModelProperty("供应商ID")
    private Long suppId;
    @ApiModelProperty("供应商编号")
    private String suppCode;
    @ApiModelProperty("供应商名称")
    private String suppName;
    @ApiModelProperty("供应商联系人")
    private String suppContactName;
    @ApiModelProperty("供应商联系电话")
    private String suppContactTel;
    @ApiModelProperty("供应商联系人邮箱")
    private String suppContactEmail;
    @ApiModelProperty("供应商传真")
    private String suppContactFax;
    @ApiModelProperty("供应商地址")
    private String suppAddress;

    @ApiModelProperty("单据类型2 [UDC]PUR:PO_TYPE2")
    @SysCode(sys = "yst-purc", mod = "PO_TYPE2")
    private String docType2;
    @ApiModelProperty("单据类型2 [UDC]PUR:PO_TYPE2")
    private String docType2Name;

    @ApiModelProperty("采购场景类型")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long sceneTypeId;

    @ApiModelProperty("采购场景类型代码")
    private String sceneTypeCode;
    @ApiModelProperty("是否需要验收 0：否 1是")
    private Integer acceptance;
    @ApiModelProperty("是否需要验收 0：否 1是")
    private String acceptanceName;

    @ApiModelProperty("单据状态 [UDC]PUR:PO_STATUS")
    @SysCode(sys = "yst-purc", mod = "PO_STATUS")
    private String docStatus;
    @ApiModelProperty("单据状态名称")
    private String docStatusName;

    @ApiModelProperty("订单时间")
    private LocalDateTime docTime;

    @ApiModelProperty("发货单日期")
    private LocalDate salDocDate;
    @ApiModelProperty("发货数量")
    private BigDecimal shippedQty;

    @ApiModelProperty("拒收数量")
    private BigDecimal rejectedQty;
    @ApiModelProperty("已取消数量")
    private BigDecimal canceledQty;

    @ApiModelProperty("采购员员工ID")
    private Long agentEmpId;
    @ApiModelProperty("采购员员工名称")
    private String empName;

    @ApiModelProperty("采购来源")
    @SysCode(sys = "yst-purc", mod = "PO_GEN_TYPE")
    private String poSource;
    private String poSourceName;

    @ApiModelProperty("本币币种")
    private String homeCurr;

    @ApiModelProperty("币种")
    private String currCode;
    private String currName;

    @ApiModelProperty("汇率")
    private BigDecimal currRate;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("含税总金额")
    private BigDecimal amt;

    @ApiModelProperty(value = "预付款金额")
    private BigDecimal prepaymentAmt;

    @ApiModelProperty("未税总金额")
    private BigDecimal netAmt;

    @ApiModelProperty("外币含税金额")
    private BigDecimal currAmt;

    @ApiModelProperty("外币不含税金额")
    private BigDecimal currNetAmt;

    @ApiModelProperty("总数量")
    private BigDecimal qty;

    @ApiModelProperty("数量单位")
    private String qtyUom;

    @ApiModelProperty("付款条款")
    private String paymentTerm;
    private String paymentTermName;

    @ApiModelProperty("要求交期")
    private LocalDateTime demandDate;

    @ApiModelProperty("供应商承诺交期")
    private LocalDateTime promiseDate;

    @ApiModelProperty("运输方式 [UDC]COM:TP_TYPE")
    @SysCode(sys = "yst-supp", mod = "TP_TYPE")
    private String transType;
    @ApiModelProperty("运输方式名称")
    private String transTypeName;

    @ApiModelProperty("收货仓库ID")
    private Long whId;
    @ApiModelProperty("仓库编号")
    private String whCode;
    @ApiModelProperty("仓库名称")
    private String whName;
    @ApiModelProperty("仓库类型")
    private String whType;
    @ApiModelProperty("收货仓库联系人")
    private String whContactName;
    @ApiModelProperty("收货仓库联系人电话")
    private String whContactTel;
    @ApiModelProperty("收货仓库联系人邮箱")
    private String whContactEmail;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    @SysCode(sys = "yst-inv", mod = "FUNC_TYPE")
    private String deter2;
    private String deter2Name;

    @ApiModelProperty("承运商供应商ID")
    private Long carrierSuppId;
    @JsonSerialize(using = ToStringSerializer.class)
    private Long carrierSuppCode;
    @JsonSerialize(using = ToStringSerializer.class)
    private Long carrierSuppName;
    @ApiModelProperty("承运商")
    private String carrier;

    @ApiModelProperty("收货单位ID")
    private Long acceptOuId;
    @ApiModelProperty("收货地址")
    private String recvAddr;
    @ApiModelProperty("收货联系人姓名")
    private String recvContactName;
    @ApiModelProperty("收货联系人电话")
    private String recvContactPhone;

    @ApiModelProperty("退货地址")
    private String returnAddr;

    @ApiModelProperty("合同ID")
    private Long contractId;
    @ApiModelProperty("合同编号")
    private String contractNo;

    @ApiModelProperty("取消时间")
    private LocalDateTime cancelTime;

    @ApiModelProperty("收货总数量")
    private BigDecimal acceptQty;

    @ApiModelProperty("关闭日期")
    private LocalDateTime closeDate;

    @ApiModelProperty("关联单据类别 来源销售单等。[UDC]COM:DOC_CLS")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String relateDocCls;
    @ApiModelProperty("关联单据类别名称")
    private String relateDocClsName;
    @ApiModelProperty("关联单据类型")
    private String relateDocType;
    @ApiModelProperty("关联单据ID")
    private Long relateDocId;
    @ApiModelProperty("关联单据编号")
    private String relateDocNo;

    @ApiModelProperty("关联单据2类别 [UDC]COM:DOC_CLS")
    private String relateDoc2Cls;
    @ApiModelProperty("关联单据2类型")
    private String relateDoc2Type;
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("关联单据2ID")
    private Long relateDoc2Id;
    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;

    @ApiModelProperty("来源单据类别[UDC]COM:DOC_CLS]")
    private String rootDocCls;
    @ApiModelProperty("来源单据类型")
    private String rootDocType;
    @ApiModelProperty("来源单据ID")
    private Long rootDocId;
    @ApiModelProperty("来源单据编号")
    private String rootDocNo;
    @ApiModelProperty("来源单据明细ID")
    private Long rootDocDid;

    @ApiModelProperty("团内订单是否已转销售订单：1是，0否")
    private Boolean salSoFlag;

    @ApiModelProperty("采购明细")
    private List<PurPodCreateDTO> purPodList;

    @ApiModelProperty("流程实例ID")
    private String procInstId;
    @ApiModelProperty("流程实例状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty(value = "提交时间")
    private LocalDateTime submitTime;
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;
    @ApiModelProperty("审批状态 [UDC]COM:APPR_STATUS")
    private String apprStatus;
    @ApiModelProperty("审批人ID")
    private Long apprUserId;
    private String apprUserName;
    @ApiModelProperty("审批意见")
    private String apprComment;

    @ApiModelProperty("地址填写方式")
    private String recvAddrMethod;
    @ApiModelProperty("收货地址类型")
    private String recvAddrType;
    @ApiModelProperty("国家")
    private String country;
    @ApiModelProperty("省编码")
    private String province;
    @ApiModelProperty("市编码")
    private String city;
    @ApiModelProperty("区编码")
    private String county;

    @ApiModelProperty("越库标识 true=是，false=否，默认值为false")
    private Boolean overStockFlag;
    @ApiModelProperty("仓库是否对接WMS true=是，false=否，默认值为false")
    private Boolean wmsWhFlag;

    @ApiModelProperty("文件服务器编码")
    private String fileCode;

    @ApiModelProperty("采购订单类型")
    private String poType;

    @ApiModelProperty("项目编码")
    private String projectCode;

    @ApiModelProperty("项目名称")
    private String projectName;

    @ApiModelProperty("是否快捷入库")
    private Boolean quickDeliveryFlag;

    @ApiModelProperty("ES2")
    private String es2;

    @ApiModelProperty("付款协议编码")
    private String protocolCode;
    @ApiModelProperty("付款协议名称")
    private String protocolName;

    @ApiModelProperty("预付款单号")
    private String payOrderNo;
    @ApiModelProperty("是否需要预付款")
    private Integer needPrepayFlag;
    @ApiModelProperty("是否已申请预付：1是，0否")
    private Integer prepayFlag;
    @ApiModelProperty("是否展示预付款申请按钮：1是，0否")
    private Integer prepayBtn;

    @ApiModelProperty("表分区字段：月")
    private Integer ym;

    @ApiModelProperty("要货类型 [UDC]yst-suplan:DEMAND_SET_TYPE")
    private String demandType;

    @ApiModelProperty("门店编码")
    private String storeCode;

    @ApiModelProperty("门店名称")
    private String storeName;

    @ApiModelProperty(value = "是否免检，true：免检，false：需要质检")
    private Boolean qt;
}
