package com.elitesland.pur.provider;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.pur.Application;
import com.elitesland.pur.dto.supp.PurSuppSubRpcDTO;
import com.elitesland.pur.dto.supp.PurSuppSubRpcQueryParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Set;

/**
 * 分部供应商.
 *
 * @author Kaiser（wang shao）
 * @date 2025/10/23 周四
 */
@FeignClient(name = Application.NAME, path = PurSuppSubProvider.PATH)
public interface PurSuppSubProvider {
    String PATH = Application.PATH + "/purSuppSub";

    @ApiOperation(value = "查询供应商列表")
    @PostMapping(value = "/queryList")
    ApiResult<PurSuppSubRpcDTO> querySuppList(@RequestBody PurSuppSubRpcQueryParam queryParam);

    @ApiOperation(value = "批量查询供应商编码和名称")
    @PostMapping(value = "/querySuppCodeName")
    ApiResult<List<IdCodeNameParam>> querySuppCodeName(@RequestBody Set<Long> ids);

    @ApiOperation(value = "批量查询供应商ID和名称")
    @PostMapping(value = "/querySuppIdName")
    ApiResult<List<IdCodeNameParam>> querySuppIdName(@RequestBody Set<String> suppCodes);
}
