package com.elitesland.pur.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明:品项采购价格
 * </p>
 *
 * @Author Darren
 * @Version 1.0
 * @Content:
 * @Date 2021/02/24
 */
@Data
@ApiModel(value = "purPurcPriceRespVO", description = "品项采购价格")
public class PurPurcPriceRpcDTO implements Serializable {

    private static final long serialVersionUID = -7088824509020545241L;
    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("公司编号")
    private String ouCode;
    /**
     * 价格类型
     */
    @ApiModelProperty("价格类型")
    @SysCode(sys = "yst-purc", mod = "PUR_PRICE_TYPE")
    private String priceType;
    @ApiModelProperty("价格类型名称")
    private String priceTypeName;
    /**
     * 品项ID
     */
    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;
    @ApiModelProperty("品项名称")
    String itemName;
    @ApiModelProperty("品项编号")
    String itemCode;
    @ApiModelProperty("规格型号")
    private String spec;
    /**
     * 品牌
     */
    @ApiModelProperty("品牌")
    private String itemBrand;
    @ApiModelProperty("品牌名称")
    String brandName;
    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;
    /**
     * 供应商编号
     */
    @ApiModelProperty("供应商编号")
    private String suppCode;
    /**
     * 供应商名称
     */
    @ApiModelProperty("供应商名称")
    private String suppName;
    /**
     * 从数量
     */
    @ApiModelProperty("从数量")
    private BigDecimal fromQty;
    /**
     * 到数量
     */
    @ApiModelProperty("到数量")
    private BigDecimal toQty;
    /**
     * 单位
     */
    @ApiModelProperty("单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    @ApiModelProperty("单位名称")
    String uomName;

    /**
     * 不含税单价
     */
    @ApiModelProperty("不含税单价")
    private BigDecimal netPrice;
    /**
     * 税率编号
     */
    @ApiModelProperty("税率编号")
    private String taxRateNo;
    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private Double taxRate;

    /**
     * 含税单价
     */
    @ApiModelProperty("含税单价")
    private BigDecimal price;
    /**
     * 币种
     */
    @ApiModelProperty("币种")
    private String currCode;
    @ApiModelProperty("币种名称")
    String currCodeName;
    /**
     * 生效时间
     */
    @ApiModelProperty("生效时间")
    private LocalDateTime validFrom;
    /**
     * 失效时间
     */
    @ApiModelProperty("失效时间")
    private LocalDateTime validTo;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;

    /**
     * 唯一标识
     */
    @ApiModelProperty("唯一标识")
    private Long uuid;
}
