package com.elitesland.pur.dto.rns;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;


/**
 * 采购退货出库单
 *
 * @author chaofeng.xia
 * @date 2023/9/25 16:16
 */
@Data
@ApiModel(value = "PurRnsRecvRpcSaveDTO", description = "采购退货出库单")
public class PurRnsRecvRpcSaveDTO implements Serializable {

    private static final long serialVersionUID = -1505283056858229802L;

    /**
     * 唯一编号ID
     */
    @ApiModelProperty("唯一编号ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    /**
     * 公司ID
     */
    @ApiModelProperty("公司编码")
    private String ouCode;

    /**
     * BUID
     */
    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty("ES11")
    private String es11;

    /**
     * 单据编号
     */
    @ApiModelProperty("单据编号")
    private String docNo;
    /**
     * 单据类型 [UDC]PUR:GR_TYPE
     */
    @ApiModelProperty("单据类型 [UDC]PUR:GR_TYPE")
    private String docType;
    /**
     * 单据状态 [UDC]PUR:RGR_STATUS
     */
    @ApiModelProperty("单据状态 [UDC]PUR:RGR_STATUS")
    private String docStatus;
    /**
     * 收货日期
     */
    @ApiModelProperty("收货日期")
    private LocalDateTime recvDate;
    /**
     * 采购订单ID
     */
    @ApiModelProperty("采购订单ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long poId;
    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;

    @ApiModelProperty("供应商编码")
    private String suppCode;
    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    /**
     * 仓库ID
     */
    @ApiModelProperty("销售发货仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long saleWhId;

    /**
     * 温层 [UDC]INV:TEMP_TYPE
     */
    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    private String deter1;
    /**
     * 功能区 [UDC]INV:FUNC_TYPE
     */
    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private String deter2;
    /**
     * 库位
     */
    @ApiModelProperty("库位")
    private String whLoc;
    /**
     * 货位
     */
    @ApiModelProperty("货位")
    private String whPosi;
    /**
     * 供应商发货单号
     */
    @ApiModelProperty("供应商发货单号")
    private String suppDocNo;
    /**
     * 收货人员工ID
     */
    @ApiModelProperty("收货人员工ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long recvEmpId;

    /**
     * 收货人员工名字
     */
    @ApiModelProperty("收货人员工名字")
    @JsonSerialize(using = ToStringSerializer.class)
    private String recvEmpName;

    /**
     * 越库标识
     */
    @ApiModelProperty("越库标识")
    private Integer crosswhFlag;
    /**
     * 总数量
     */
    @ApiModelProperty("总数量")
    private BigDecimal qty;

    @ApiModelProperty("总拒收数量")
    private BigDecimal rejectQty;
    /**
     * 数量单位
     */
    @ApiModelProperty("数量单位")
    private String qtyUom;
    /**
     * 总数量2
     */
    @ApiModelProperty("总数量2")
    private Double qty2;
    /**
     * 数量2单位
     */
    @ApiModelProperty("数量2单位")
    private String qty2Uom;
    /**
     * 净重
     */
    @ApiModelProperty("净重")
    private Double netWeight;
    /**
     * 毛重
     */
    @ApiModelProperty("毛重")
    private Double grossWeight;
    /**
     * 重量单位
     */
    @ApiModelProperty("重量单位")
    private String weightUom;
    /**
     * 体积
     */
    @ApiModelProperty("体积")
    private Double volume;
    /**
     * 体积单位
     */
    @ApiModelProperty("体积单位")
    private String volumeUom;
    /**
     * 税额
     */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
    /**
     * 含税金额
     */
    @ApiModelProperty("含税金额")
    private BigDecimal amt;
    /**
     * 不含税金额
     */
    @ApiModelProperty("不含税金额")
    private BigDecimal netAmt;
    /**
     * 记账币种
     */
    @ApiModelProperty("记账币种")
    private String homeCurr;
    /**
     * 交易币种
     */
    @ApiModelProperty("交易币种")
    private String currCode;
    /**
     * 汇率
     */
    @ApiModelProperty("汇率")
    private Double currRate;
    /**
     * 外币不含税金额
     */
    @ApiModelProperty("外币不含税金额")
    private BigDecimal currNetAmt;
    /**
     * 外币含税金额
     */
    @ApiModelProperty("外币含税金额")
    private BigDecimal currAmt;
    /**
     * 生成类型 [UDC]COM:DOC_GEN_TYPE
     */
    @ApiModelProperty("生成类型 [UDC]COM:DOC_GEN_TYPE")
    private String genType;
    /**
     * 生成类型2
     */
    @ApiModelProperty("生成类型2")
    private String genType2;
    /**
     * 根ID
     */
    @ApiModelProperty("根ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long rootId;
    /**
     * 关联单据类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据类别 [UDC]COM:DOC_CLS")
    private String relateDocCls;
    /**
     * 关联单据类型
     */
    @ApiModelProperty("关联单据类型")
    private String relateDocType;
    /**
     * 关联单据ID
     */
    @ApiModelProperty("关联单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocId;
    /**
     * 关联单据编号
     */
    @ApiModelProperty("关联单据编号")
    private String relateDocNo;
    /**
     * 关联单据2类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据2类别 [UDC]COM:DOC_CLS")
    private String relateDoc2Cls;
    /**
     * 关联单据2类型
     */
    @ApiModelProperty("关联单据2类型")
    private String relateDoc2Type;
    /**
     * 关联单据2ID - 发货单ID
     */
    @ApiModelProperty("关联单据2ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDoc2Id;
    /**
     * 关联单据2编号 - 供应商发货编号
     */
    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;
    /**
     * 关联ID
     */
    @ApiModelProperty("关联ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateId;
    /**
     * 关联编号
     */
    @ApiModelProperty("关联编号")
    private String relateNo;
    /**
     * 关联2ID
     */
    @ApiModelProperty("关联2ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relate2Id;
    /**
     * 关联2编号
     */
    @ApiModelProperty("关联2编号")
    private String relate2No;

    @ApiModelProperty("是否含税")
    private Integer taxInclFlag;

    @ApiModelProperty("税码")
    private String taxCode;

    @ApiModelProperty("税率编号")
    private String taxRateNo;

    @ApiModelProperty("税率")
    private Double taxRate;

    /**
     * 逻辑删除，0：无接口，1：有接口
     */
    @ApiModelProperty("逻辑删除，0：无接口，1：有接口")
    private Integer intfFlag;

    @ApiModelProperty("采购收货单明细")
    private List<PurRnsRecvDSaveRpcDTO> purRnsRecvDSaveRpcDTOList;

    @ApiModelProperty("采购结算对账单ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long purAccountCheckId;

    @ApiModelProperty(value = "是否生成采购结算对账单，0：未生成，1：已生成")
    private Integer accountFlag;

    @ApiModelProperty("外部单据公司")
    private String outerOu;

    @ApiModelProperty("外部单据类型")
    private String outerType;

    @ApiModelProperty("外部单据编号")
    private String outerNo;

    @ApiModelProperty("外部单据id")
    @JsonSerialize(using = ToStringSerializer.class)
    @NotNull
    private Long outerId;

    /**
     * 文件服务器编码
     */
    @ApiModelProperty("文件服务器编码")
    private String fileCode;

    private Boolean groupFlag;

    /**
     * 是否团内 [UDC]ORG:SUPP_TYPE2
     */
    @ApiModelProperty("是否团内 [UDC]ORG:SUPP_TYPE2")
    private String insideStatus;

    @ApiModelProperty("仓库联系人电话")
    private String tel;

    /**
     * 供应商联系电话
     */
    @ApiModelProperty("供应商联系电话")
    private String suppContactTel;
    /**
     * 供应商联系人邮箱
     */
    @ApiModelProperty("供应商联系人邮箱")
    private String suppContactEmail;


    @ApiModelProperty("收货地址")
    private String detailAddr;

    @ApiModelProperty("员工ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long empId;

    @ApiModelProperty("付款条款")
    private String paymentTerm;

    @ApiModelProperty("员工")
    private String empCode;

    private Boolean isFromSsFlag;

    @ApiModelProperty("运输方式 [UDC]COM:TP_TYPE")
    private String transType;

    @ApiModelProperty("收货地址")
    private String recvAddr;

    @ApiModelProperty("单据类型")
    String poType;

    @ApiModelProperty("采购场景ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long sceneTypeId;

    @ApiModelProperty("采购场景编码")
    private String sceneTypeCode;

    @ApiModelProperty("省编码")
    private String province;

    @ApiModelProperty("市编码")
    private String city;

    @ApiModelProperty("区编码")
    private String county;

    @ApiModelProperty("国家")
    private String country;

    @ApiModelProperty("总签收数量")
    private BigDecimal confirmQty;

    @ApiModelProperty("总签收数量2")
    private BigDecimal confirmQty2;

    @ApiModelProperty("已签收含税金额")
    private BigDecimal confirmAmt;

    @ApiModelProperty("已签收不含税金额")
    private BigDecimal confirmNetAmt;

    @ApiModelProperty("已签收外币含税金额")
    private BigDecimal confirmCurrAmt;

    @ApiModelProperty("已签收外币不含税金额")
    private BigDecimal confirmCurrNetAmt;

    @ApiModelProperty("签收时间")
    private LocalDateTime confirmTime;

    @ApiModelProperty("供应商联系人")
    private String suppContactName;

    @ApiModelProperty("单据类别")
    private String docCls;

    @ApiModelProperty("记账日期")
    private LocalDateTime finDate;
}
