package com.elitesland.pur.dto.account;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/07/31
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "purAccountCheckDtlRpcDTO", description = "采购对账单明细表")
public class PurAccountCheckDtlRpcDTO implements Serializable {
    private static final long serialVersionUID = 560084368657998263L;

    @ApiModelProperty("ID")
    private Long id;

    @ApiModelProperty("对账单编号")
    private String docNo;

    @ApiModelProperty("主表ID")
    private Long masId;

    @ApiModelProperty("业务单据明细ID")
    private Long billDId;

    @ApiModelProperty("业务单据ID")
    private Long billId;

    @ApiModelProperty("对账单行号")
    private BigDecimal lineNo;


    @ApiModelProperty("关联单据类别 [UDC]COM:DOC_CLS")
    private String relateDocCls;

    @ApiModelProperty("单据日期")
    private LocalDateTime relateDocDate;

    @ApiModelProperty("收发货单编码")
    private String relateDocNo;

    @ApiModelProperty("关联单据ID")
    private Long relateDocId;

    @ApiModelProperty("关联单据明细ID")
    private Long relateDocDid;

    @ApiModelProperty("收发货单行号")
    private BigDecimal relateDocLine;

    @ApiModelProperty("关联单据类别2")
    private String relateDoc2Cls;

    @ApiModelProperty("订/退单编码")
    private String relateDoc2No;

    @ApiModelProperty("关联单据2ID")
    private Long relateDoc2Id;

    @ApiModelProperty("关联单据明细2ID")
    private Long relateDoc2Did;

    @ApiModelProperty("订/退单行号")
    private BigDecimal relateDoc2Line;

    @ApiModelProperty("付款协议编码")
    private String protocolCode;
}
