package com.elitesland.pur.dto.supp;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/10/23 周四
 */
@Getter
@Setter
public class PurSuppSubRpcDTO implements Serializable {
    @Serial
    private static final long serialVersionUID = 2200443137693600169L;

    @ApiModelProperty("供应商ID")
    private Long id;
    @ApiModelProperty("供应商编码")
    private String suppCode;
    @ApiModelProperty("供应商名称")
    private String suppName;
    @ApiModelProperty("供应商简称")
    private String suppAbbr;

    @ApiModelProperty("供应商英文名称")
    private String supplier;

    @ApiModelProperty("供应商类型 [UDC]yst-purc:SUPP_TYPE")
    @SysCode(sys = "yst-purc", mod = "SUPP_TYPE")
    private String suppType;
    private String suppTypeName;

    @ApiModelProperty("供应商类别 [UDC]yst-purc:SUPP_TYPE2")
    @SysCode(sys = "yst-purc", mod = "SUPP_TYPE2")
    private String suppType2;
    private String suppType2Name;

    @ApiModelProperty("供应商状态 [UDC]yst-purc:SUPP_STATUS")
    @SysCode(sys = "yst-purc", mod = "SUPP_STATUS")
    private String suppStatus;
    private String suppStatusName;

    @ApiModelProperty("供应商(企业)性质 [UDC]yst-purc:COMP_PROP")
    @SysCode(sys = "yst-purc", mod = "COMP_PROP")
    private String compProp;
    private String compPropName;

    @ApiModelProperty("供应商基本类型")
    @SysCode(sys = "yst-purc", mod = "SUPP_BASE_TYPE")
    private String suppBaseType;
    private String suppBaseTypeName;

    @ApiModelProperty("行业类型 [UDC]yst-purc:INDUS_FLAG")
    @SysCode(sys = "yst-purc", mod = "INDUS_FLAG")
    private String indusFlag1;
    private String indusFlag1Name;

    @ApiModelProperty("注册资金")
    private String registerFund;
    @ApiModelProperty("注册地址")
    private String registerAddress;

    @ApiModelProperty("内部交易公司ID")
    private Long ouId2;
    @ApiModelProperty("内部交易公司编码")
    private String ouCode2;
    @ApiModelProperty("内部交易公司名称")
    private String ouName2;

    @ApiModelProperty("纳税人识别号")
    private String taxPayerId;
    @ApiModelProperty("统一信用代码")
    private String certNo;

    @ApiModelProperty("ERP供应商编码")
    private String erpSuppCode;

    @ApiModelProperty("法人姓名(代表)")
    private String reprName;
    @ApiModelProperty("法人手机号")
    private String legalPersonPhone;
    @ApiModelProperty("法人邮箱")
    private String legalPersonMailbox;
    @ApiModelProperty("法人证件类型 [UDC]PUR:CERTIFICATE_TYPE")
    @SysCode(sys = "yst-purc", mod = "CERTIFICATE_TYPE")
    private String certificateType;
    private String certificateTypeName;
    @ApiModelProperty("法人证件编码")
    private String certificateCode;

    @ApiModelProperty("主营品类 [UDC]PUR:MAIN_CATEGORY")
    @SysCode(sys = "yst-purc", mod = "MAIN_CATEGORY")
    private String mainCategory;
    private String mainCategoryName;

    @ApiModelProperty("厂房性质 [UDC]PUR:PLANT_NATURE")
    @SysCode(sys = "yst-purc", mod = "PLANT_NATURE")
    private String plantNature;
    private String plantNatureName;

    @ApiModelProperty("认证体系 [UDC]PUR:CERTIFICATION_SYSTEM")
    @SysCode(sys = "yst-purc", mod = "CERTIFICATION_SYSTEM")
    private String certificationSystem;
    private String certificationSystemName;

    @ApiModelProperty("产品执行标准")
    private String productPerformanceStandards;

    @ApiModelProperty("质量检验")
    private String qualityInspection;

    @ApiModelProperty("检验范围")
    private String inspectionScope;

    @ApiModelProperty("供货质量记录")
    private String deliveryQualityRecord;

    @ApiModelProperty("主要生产设备")
    private String mainProductionEquipment;

    @ApiModelProperty("经营范围")
    private String businessScope;

    @ApiModelProperty("企业简介")
    private String companyProfile;

    @ApiModelProperty("付款方式 [UDC]yst-purc:PAY_TYPE")
    @SysCode(sys = "yst-purc", mod = "PAY_TYPE")
    private String payMethod;
    private String payMethodName;

    @ApiModelProperty("默认发票类型 [UDC]COM:INV_TYPE")
    @SysCode(sys = "yst-supp", mod = "INV_TYPE")
    private String invType;
    private String invTypeName;

    @ApiModelProperty("税率编号")
    private String taxRateNo;

    @ApiModelProperty("纳税人类型 [UDC]ORG:PAYER_TYPE")
    @SysCode(sys = "yst-supp", mod = "PAYER_TYPE")
    private String taxPayerType;
    private String taxPayerTypeName;

    @ApiModelProperty("邮编")
    private String zipCode;

    @ApiModelProperty("公司ID")
    private Long ouId;
    @ApiModelProperty("公司编码")
    private String ouCode;
    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("地址号")
    private Long addrNo;

    @ApiModelProperty("公司邮箱")
    private String registerMail;

    @ApiModelProperty("主营品类简介")
    private String categoryDescription;

    @ApiModelProperty("币种")
    private String currCode;

    @ApiModelProperty("公司注册日期")
    private LocalDateTime registerDate;

    @ApiModelProperty("入库免检，1：免检，0：需要质检")
    private Boolean qt;

    @ApiModelProperty("付款协议编码")
    private String protocolCode;

    @ApiModelProperty("内外部 [UDC]PUR:IO_TYPE")
    @SysCode(sys = "yst-supp", mod = "IO_TYPE")
    private String ioType;
    private String ioTypeName;

    @ApiModelProperty("外部系统id")
    private String outSysKey;

    @ApiModelProperty("批号前缀 [UDC]INV:LOT_MANU_FACTORY")
    @SysCode(sys = "yst-supp", mod = "LOT_MANU_FACTORY")
    private String lotNoPrefix;
    private String lotNoPrefixName;

    @ApiModelProperty("是否客商一体UDC:PUR:TRUE_OR_FALSE")
    @SysCode(sys = "yst-supp", mod = "TRUE_OR_FALSE")
    private String clientVendor;
    private String clientVendorName;

    @ApiModelProperty("是否产品相关供应商UDC:PUR:TRUE_OR_FALSE")
    @SysCode(sys = "yst-supp", mod = "TRUE_OR_FALSE")
    private String productSupp;
    private String productSuppName;

    @ApiModelProperty("是否医药供应商UDC:PUR:TRUE_OR_FALSE")
    @SysCode(sys = "yst-supp", mod = "TRUE_OR_FALSE")
    private String pharmaSupp;
    private String pharmaSuppName;

    @ApiModelProperty("证照分类 [UDC]PUR:LICENSE_CLASS")
    @SysCode(sys = "yst-supp", mod = "LICENSE_CLASS")
    private String licenseClass;
    private String licenseClassName;

    @ApiModelProperty("供应商阶段 [UDC]PUR:SUPPLIER_PHASE")
    @SysCode(sys = "yst-supp", mod = "SUPPLIER_PHASE")
    private String supplierPhase;
    private String supplierPhaseName;

    @ApiModelProperty("供应商等级 [UDC]PUR:SUPPLIER_LEVEL")
    @SysCode(sys = "yst-supp", mod = "SUPPLIER_LEVEL")
    private String supplierLevel;
    private String supplierLevelName;

    @ApiModelProperty("经营方式 [UDC]PUR:BUSINESS_MODEL")
    @SysCode(sys = "yst-supp", mod = "BUSINESS_MODEL")
    private String businessModel;
    private String businessModelName;

    @ApiModelProperty(value = "适用质量体系 医药行业字段")
    private String applicableQualitySystem;
}
