package com.elitesland.pur.dto.po;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.sys.component.med.BaseModelVOMedItem;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/10/17 周五
 */
@Getter
@Setter
public class PurPodCreateDTO extends BaseModelVOMedItem implements Serializable {

    @ApiModelProperty("主表ID")
    private Long masId;

    @ApiModelProperty("关联单据编号")
    private String poNo;

    @ApiModelProperty("采购订单编码")
    private String docNo;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("公司ID")
    private Long ouId;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("BUID")
    private Long buId;

    @ApiModelProperty("行号")
    private BigDecimal lineNo;

    @ApiModelProperty("收货仓库ID")
    private Long whId;
    @ApiModelProperty("仓库编号")
    private String whCode;
    @ApiModelProperty("仓库类型")
    private String whType;
    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    @SysCode(sys="yst-inv",mod = "FUNC_TYPE")
    private String deter2;
    private String deter2Name;

    @ApiModelProperty("供应商ID")
    private Long suppId;

    @ApiModelProperty("品项ID")
    private Long itemId;
    @ApiModelProperty("品项编号")
    private String itemCode;
    @ApiModelProperty("品项名称")
    private String itemName;
    @ApiModelProperty("品项规格")
    private String itemSpec;

    @ApiModelProperty("条码")
    private String barcode;

    @ApiModelProperty("数量")
    private BigDecimal qty;

    @ApiModelProperty("通知发货数量")
    private BigDecimal shipmentQty;

    @ApiModelProperty("单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;

    @ApiModelProperty("基本单位数量")
    private BigDecimal qty2;

    @ApiModelProperty("基本单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom2;
    private String uom2Name;

    @ApiModelProperty("单位转换率")
    private BigDecimal uomRatio;

    @ApiModelProperty("保留小数位")
    private Integer decimalPlaces;

    @ApiModelProperty("不含税价格")
    private BigDecimal netPrice;

    @ApiModelProperty("含税单价")
    private BigDecimal price;

    @ApiModelProperty("价格类型")
    private String priceType;

    @ApiModelProperty("未税单价(外币）")
    private BigDecimal currNetPrice;

    @ApiModelProperty("含税单价(外币)")
    private BigDecimal currPrice;

    @ApiModelProperty("价格本价格")
    private BigDecimal pbPrice;

    @ApiModelProperty("价格本币种")
    private String pbCurr;
    private String pbCurrName;

    @ApiModelProperty("价格本单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String pbUom;
    private String pbUomName;

    @ApiModelProperty("商品税类型")
    private String itemTaxType;

    @ApiModelProperty("税率编号")
    private String taxRateNo;
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("含税金额")
    private BigDecimal amt;

    @ApiModelProperty("不含税金额")
    private BigDecimal netAmt;

    @ApiModelProperty("外币含税金额")
    private BigDecimal currAmt;

    @ApiModelProperty("外币不含税金额")
    private BigDecimal currNetAmt;

    @ApiModelProperty("本币币种")
    private String homeCurr;

    @ApiModelProperty("币种")
    private String currCode;
    private String currName;

    @ApiModelProperty("汇率")
    private BigDecimal currRate;

    @ApiModelProperty("已出库数量")
    private BigDecimal shippedQty;

    @ApiModelProperty("已收数量")
    private BigDecimal acceptQty;

    @ApiModelProperty("已退数量")
    private BigDecimal returnedQty;

    @ApiModelProperty("收货单位")
    private String acceptUom;

    @ApiModelProperty("收货日期")
    private LocalDateTime acceptDate;

    @ApiModelProperty("实际未发数量")
    private BigDecimal acUnshipQty;

    @ApiModelProperty("要求交期")
    private LocalDateTime demandDate;

    @ApiModelProperty("最大允差比例")
    private BigDecimal toleranceRatio;

    @ApiModelProperty("收货允差")
    private BigDecimal recvTolerance;

    @ApiModelProperty("已取消数量")
    private BigDecimal canceledQty;

    @ApiModelProperty("关联单据类别 [UDC]COM:DOC_CLS")
    @SysCode(sys = "yst-supp",mod = "DOC_CLS")
    private String relateDocCls;
    @ApiModelProperty("关联单据类别名称")
    private String relateDocClsName;
    @ApiModelProperty("关联单据类型")
    private String relateDocType;
    @ApiModelProperty("关联单据ID")
    private Long relateDocId;
    @ApiModelProperty("关联单据编号")
    private String relateDocNo;
    @ApiModelProperty("关联单据明细ID")
    private Long relateDocDid;
    @ApiModelProperty("关联单据行号")
    private BigDecimal relateDocLineno;

    @ApiModelProperty("关联单据2类别 [UDC]COM:DOC_CLS")
    @SysCode(sys = "yst-supp",mod = "DOC_CLS")
    private String relateDoc2Cls;
    @ApiModelProperty("关联单据2类别名称")
    private String relateDoc2ClsName;
    @ApiModelProperty("关联单据2类型")
    private String relateDoc2Type;
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("关联单据2ID")
    private Long relateDoc2Id;
    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("关联单据2明细ID")
    private Long relateDoc2Did;
    @ApiModelProperty("关联单据2行号")
    private BigDecimal relateDoc2Lineno;

    @ApiModelProperty("来源单据类别[UDC]COM:DOC_CLS]")
    private String rootDocCls;
    @ApiModelProperty("来源单据类型")
    private String rootDocType;
    @ApiModelProperty("来源单据ID")
    private Long rootDocId;
    @ApiModelProperty("来源单据编号")
    private String rootDocNo;
    @ApiModelProperty("来源单据明细ID")
    private Long rootDocDid;
    @ApiModelProperty("来源单据行号")
    private Integer rootDocLineNo;

    @ApiModelProperty("是否启用批次")
    private Boolean lotFlag;

    @ApiModelProperty("ES2")
    private String es2;

    @ApiModelProperty("品牌code")
    private String dbrand;
    private String dbrandName;

    @ApiModelProperty("保质期天数")
    private Integer storeExpireDays;

    @ApiModelProperty("订单日期")
    private LocalDateTime docTime;

    @ApiModelProperty("请款人员工ID")
    private Long docEmpId;
    private String docEmpName;

    @ApiModelProperty("收货单位ID")
    private Long acceptOuId;
    @ApiModelProperty("收货地址类型")
    private String recvAddrType;
    @ApiModelProperty("国家")
    private String country;
    @ApiModelProperty("省编码")
    private String province;
    @ApiModelProperty("市编码")
    private String city;
    @ApiModelProperty("区编码")
    private String county;
    @ApiModelProperty("收货门店编码")
    private String recvStoreCode;
    @ApiModelProperty("收货门店名称")
    private String recvStoreName;
    @ApiModelProperty("收货地址")
    private String recvAddr;
    @ApiModelProperty("收货联系人姓名")
    private String recvContactName;
    @ApiModelProperty("收货联系人电话")
    private String recvContactPhone;

    @ApiModelProperty("退货申请数量")
    private BigDecimal rpoReturnQty;

    @ApiModelProperty("moq：最小起订量")
    private BigDecimal moq;
    @ApiModelProperty("商品采购交期（天） 取自商品主数据")
    private Integer purDelivPeriod;
    @ApiModelProperty("已转单数量")
    private BigDecimal transferQty;

    @ApiModelProperty("收货批次")
    private String lotNo;

    @ApiModelProperty("生产日期")
    private LocalDateTime manuDate;

    @ApiModelProperty("过期日期")
    private LocalDateTime expireDate;

    @ApiModelProperty("保质期天数")
    private Integer expireDays;

    @ApiModelProperty("入库日期")
    private LocalDateTime recvDate;

    @ApiModelProperty("采购场景ID")
    private Long sceneTypeId;

    @ApiModelProperty("采购场景编码")
    private String sceneTypeCode;

    @ApiModelProperty("拒收数量")
    private BigDecimal rejectedQty;

    @ApiModelProperty(value = "是否管理库存")
    private Boolean manageInvFlag;

    @ApiModelProperty("结算含税单价")
    private BigDecimal amortizedPrice;

    @ApiModelProperty("销售含税金额")
    private BigDecimal lastPathSaleAmt;

    @ApiModelProperty("销售含税单价")
    private BigDecimal lastPathSalePrice;

    @ApiModelProperty("合同号")
    private String contractNo;

    @ApiModelProperty("图稿编号")
    private String draftNo;

    @ApiModelProperty(value = "预付款比例（%）")
    private BigDecimal prepaymentRatio;
    @ApiModelProperty(value = "预付款金额")
    private BigDecimal prepaymentAmt;

    @ApiModelProperty(value = "是否赠品 0：否 1：是")
    private Integer gift;
}
