package com.elitesland.pur.common.inter.impl;

import com.elitesland.pur.common.inter.PurInter;
import com.elitesland.pur.common.inter.PurRetryRecordRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/7/10 周四
 */
@Component
@ConditionalOnMissingBean(PurRetryRecordRepository.class)
public class NoopPurRetryRecordRepository implements PurRetryRecordRepository {
    private static final Logger logger = LoggerFactory.getLogger(NoopPurRetryRecordRepository.class);

    @Override
    public void saveRecord(PurInter inter, Long docId, String docNo, String errorMsg) {
        logger.warn("未找到有效的推送记录持久化方法: {}, {}, {}", inter, docNo, docId);
    }
}
