package com.elitesland.pur.dto.rns;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

@Data
@ApiModel(value = "PurRnsSaveRpcParam", description = "退货申请保存参数")
public class PurRnsSaveRpcParam implements Serializable {

    private static final long serialVersionUID = 1778196094175766334L;

    @ApiModelProperty("采购收货单id")
    private Long docId;

    private String remark;

    @ApiModelProperty("退货类型")
    private String refundType;

    @ApiModelProperty("退货类型名")
    private String refundTypeName;

    private List<PurRnsSaveRpcDetail> details;

    @Data
    public static class PurRnsSaveRpcDetail {

        @ApiModelProperty("明细id")
        private Long id;

        @ApiModelProperty("实收数量")
        private BigDecimal qty;

        @ApiModelProperty("单位")
        private String uom;

        @ApiModelProperty("单位转换率")
        private BigDecimal uomRatio;
    }
}
