package com.elitesland.pur.dto.gr;

import com.elitesland.pur.base.BaseModelVO;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 采购收货单主表
 *
 * @author chaofeng.xia
 * @date 2024/4/1 19:11
 */
@Data
@ApiModel(value = "pur_gr", description = "采购收货单")
public class PurGrPageRpcDTO extends BaseModelVO implements Serializable {

    private static final long serialVersionUID = 399175131090854991L;
    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;
    private String ouCode;
    private String ouName;
    /**
     * BUID
     */
    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty("采购组织名称")
    private String buName;

    /**
     * 单据编号
     */
    @ApiModelProperty("单据编号")
    private String docNo;

    @ApiModelProperty("采购单类型")
    private String poType;

    @ApiModelProperty("单据Id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * 单据类型 [UDC]PUR:GR_TYPE
     */
    @ApiModelProperty("单据类型 [UDC]PUR:GR_TYPE")
    @SysCode(sys = "yst-purc", mod = "GR_TYPE")
    private String docType;
    private String docTypeName;

    /**
     * 单据状态 [UDC]PUR:GR_STATUS
     */
    @ApiModelProperty("单据状态 [UDC]PUR:GR_STATUS")
    @SysCode(sys = "yst-purc", mod = "GR_STATUS")
    private String docStatus;
    private String docStatusName;
    /**
     * 收货日期
     */
    @ApiModelProperty("收货日期")
    private LocalDateTime recvDate;
    /**
     * 采购订单ID
     */
    @ApiModelProperty("采购订单ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long poId;
    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;
    private String suppCode;
    private String suppName;
    @ApiModelProperty("供应商联系电话")
    private String suppContactTel;
    @ApiModelProperty("供应商联系人邮箱")
    private String suppContactEmail;
    @ApiModelProperty("供应商联系人")
    private String suppContactName;
    @ApiModelProperty("供应商详细地址")
    private String returnAddr;
    @ApiModelProperty("省编码")
    private String province;
    private String provinceName;

    @ApiModelProperty("市编码")
    private String city;
    private String cityName;

    @ApiModelProperty("区编码")
    private String county;
    private String countyName;

    @ApiModelProperty("国家")
    @SysCode(sys = "yst-supp", mod = "COUNTRY")
    private String country;
    private String countryName;
    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;
    private String whCode;
    private String whName;
    /**
     * 销售发货仓库ID
     */
    @ApiModelProperty("销售发货仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long saleWhId;

    /**
     * 温层 [UDC]INV:TEMP_TYPE
     */
    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    @SysCode(sys = "yst-inv", mod = "TEMP_TYPE")
    private String deter1;
    private String deter1Name;
    /**
     * 功能区 [UDC]INV:FUNC_TYPE
     */
    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    @SysCode(sys = "yst-inv", mod = "FUNC_TYPE")
    private String deter2;
    private String deter2Name;
    /**
     * 客户标识
     */
    @ApiModelProperty("客户标识")
    private String deter3;
    private String deter3Name;
    /**
     * 限定4
     */
    @ApiModelProperty("限定4")
    private String deter4;
    /**
     * 限定5
     */
    @ApiModelProperty("限定5")
    private String deter5;
    /**
     * 限定6
     */
    @ApiModelProperty("限定6")
    private String deter6;
    /**
     * 限定7
     */
    @ApiModelProperty("限定7")
    private String deter7;
    /**
     * 限定8
     */
    @ApiModelProperty("限定8")
    private String deter8;
    /**
     * 库位
     */
    @ApiModelProperty("库位")
    private String whLoc;
    /**
     * 货位
     */
    @ApiModelProperty("货位")
    private String whPosi;
    /**
     * 供应商发货单号
     */
    @ApiModelProperty("供应商发货单号")
    private String suppDocNo;
    /**
     * 收货人员工ID
     */
    @ApiModelProperty("收货人员工ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long recvEmpId;

    @ApiModelProperty("收货人员工名字")
    @JsonSerialize(using = ToStringSerializer.class)
    private String recvEmpName;
    /**
     * 越库标识
     */
    @ApiModelProperty("越库标识")
    private Integer crosswhFlag;
    /**
     * 总数量
     */
    @ApiModelProperty("总数量")
    private BigDecimal qty;
    private BigDecimal qtySum;

    @ApiModelProperty("总拒收数量")
    private BigDecimal rejectQty;
    /**
     * 数量单位
     */
    @ApiModelProperty("数量单位")
    private String qtyUom;
    /**
     * 总数量2
     */
    @ApiModelProperty("总数量2")
    private BigDecimal qty2;
    /**
     * 数量2单位
     */
    @ApiModelProperty("数量2单位")
    private String qty2Uom;
    /**
     * 净重
     */
    @ApiModelProperty("净重")
    private Double netWeight;
    /**
     * 毛重
     */
    @ApiModelProperty("毛重")
    private Double grossWeight;
    /**
     * 重量单位
     */
    @ApiModelProperty("重量单位")
    private String weightUom;
    /**
     * 体积
     */
    @ApiModelProperty("体积")
    private Double volume;
    /**
     * 体积单位
     */
    @ApiModelProperty("体积单位")
    private String volumeUom;
    /**
     * 税额
     */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
    /**
     * 含税金额
     */
    @ApiModelProperty("含税金额")
    private BigDecimal amt;
    /**
     * 不含税金额
     */
    @ApiModelProperty("不含税金额")
    private BigDecimal netAmt;
    /**
     * 记账币种
     */
    @ApiModelProperty("记账币种")
    private String homeCurr;
    /**
     * 交易币种
     */
    @ApiModelProperty("交易币种")
    private String currCode;
    private String currName;
    /**
     * 汇率
     */
    @ApiModelProperty("汇率")
    private Double currRate;
    /**
     * 外币不含税金额
     */
    @ApiModelProperty("外币不含税金额")
    private BigDecimal currNetAmt;
    /**
     * 外币含税金额
     */
    @ApiModelProperty("外币含税金额")
    private BigDecimal currAmt;
    /**
     * 生成类型 [UDC]COM:DOC_GEN_TYPE
     */
    @ApiModelProperty("生成类型 [UDC]COM:DOC_GEN_TYPE")
    @SysCode(sys = "yst-supp", mod = "DOC_GEN_TYPE")
    private String genType;
    private String genTypeName;
    /**
     * 生成类型2
     */
    @ApiModelProperty("生成类型2")
    private String genType2;
    /**
     * 根ID
     */
    @ApiModelProperty("根ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long rootId;
    /**
     * 关联单据类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据类别 [UDC]COM:DOC_CLS")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String relateDocCls;
    private String relateDocClsName;
    /**
     * 关联单据类型
     */
    @ApiModelProperty("关联单据类型")
    private String relateDocType;
    /**
     * 关联单据ID
     */
    @ApiModelProperty("关联单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocId;
    /**
     * 关联单据编号
     */
    @ApiModelProperty("关联单据编号")
    private String relateDocNo;
    /**
     * 关联单据2类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据2类别 [UDC]COM:DOC_CLS")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String relateDoc2Cls;
    private String relateDoc2ClsName;
    /**
     * 关联单据2类型
     */
    @ApiModelProperty("关联单据2类型")
    private String relateDoc2Type;
    /**
     * 关联单据2ID
     */
    @ApiModelProperty("关联单据2ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDoc2Id;
    /**
     * 关联单据2编号
     */
    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;
    /**
     * 关联ID
     */
    @ApiModelProperty("关联ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateId;
    /**
     * 关联编号
     */
    @ApiModelProperty("关联编号")
    private String relateNo;
    /**
     * 关联2ID
     */
    @ApiModelProperty("关联2ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relate2Id;
    /**
     * 关联2编号
     */
    @ApiModelProperty("关联2编号")
    private String relate2No;
    /**
     * ES1
     */
    @ApiModelProperty("ES1")
    private String es1;

    @ApiModelProperty("采购场景")
    private String es11;

    /**
     * ES2
     */
    @ApiModelProperty("ES2")
    private String es2;
    /**
     * ES3
     */
    @ApiModelProperty("ES3")
    private String es3;
    /**
     * ES4
     */
    @ApiModelProperty("ES4")
    private String es4;
    /**
     * ES5
     */
    @ApiModelProperty("ES5")
    private String es5;

    @ApiModelProperty("是否含税")
    private Integer taxInclFlag;

    @ApiModelProperty("税码")
    private String taxCode;

    @ApiModelProperty("税率编号")
    private String taxRateNo;

    @ApiModelProperty("税率")
    private Double taxRate;

    @ApiModelProperty("外部单据公司")
    private String outerOu;

    @ApiModelProperty("外部单据类型")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String outerType;
    private String outerTypeName;

    @ApiModelProperty("外部单据编号")
    private String outerNo;

    @ApiModelProperty("外部单据id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long outerId;

    @ApiModelProperty("是否有接口0:无接口,1:有接口")
    private Integer intfFlag;

    /**
     * 文件服务器编码
     */
    @ApiModelProperty("文件服务器编码")
    private String fileCode;

    @ApiModelProperty("采购收货单明细")
    private List<PurGrDRpcDTO> purGrDRpcDTOList;

    private Boolean groupFlag;

    @ApiModelProperty("京云仓采购入库单号")
    private String jdPoOrderNo;

    @ApiModelProperty("配额发生")
    BigDecimal partsAmtAdd;

    @ApiModelProperty("配额分配")
    BigDecimal partsAmtUse;

    @ApiModelProperty("运输方式 [UDC]COM:TP_TYPE")
    @SysCode(sys = "yst-supp", mod = "TP_TYPE")
    private String transType;
    private String transTypeName;

    @ApiModelProperty("收货地址")
    private String recvAddr;

    @ApiModelProperty("同步销售发货单失败状态")
    private Boolean syncDoStatus;

    @ApiModelProperty("同步销售发货单失败原因")
    private String syncDoFailReason;

    @ApiModelProperty("详细地址")
    private String shipmentDetailaddr;

    @ApiModelProperty("发运联系人")
    private String shipmentContactName;

    @ApiModelProperty("发运联系电话")
    private String shipmentContactTel;

    @ApiModelProperty("承运商联系人")
    private String carrierContactName;

    @ApiModelProperty("承运商联系电话")
    private String carrierContactTel;

    @ApiModelProperty("承运商名称")
    private String carrierSuppName;

    @ApiModelProperty("收货联系电话")
    private String tel;

    @ApiModelProperty("采购场景ID")
    private Long sceneTypeId;

    @ApiModelProperty("采购场景编码")
    private String sceneTypeCode;

    @ApiModelProperty("采购订单订购日期")
    private LocalDateTime poDocTime;

    @ApiModelProperty("出货方式")
    private String sellMethod;

    @ApiModelProperty("京云仓编码")
    private String jdwhCode;

    @ApiModelProperty("单据类别")
    private String docCls;

    @ApiModelProperty("越库标识 true=是，false=否，默认值为false")
    private Boolean overStockFlag;

    @ApiModelProperty("来源单据编号")
    private String rootDocNo;

    @ApiModelProperty("要交日期")
    private LocalDateTime demandDate;

    @ApiModelProperty("预计到货日期")
    private LocalDateTime etaDate;

    @ApiModelProperty("项目编码")
    private String projectCode;

    @ApiModelProperty("项目名称")
    private String projectName;

    @ApiModelProperty("总订购数量")
    private BigDecimal poQty;

    @ApiModelProperty("本次总收货数量")
    private BigDecimal sumQty;

    @ApiModelProperty("总订购数量")
    private BigDecimal sumPoQty;

    @ApiModelProperty("可收货总数量")
    private BigDecimal sumAvalQty;

    @ApiModelProperty("含税总额")
    BigDecimal sumCurrAmt;

    @ApiModelProperty("未税总额")
    BigDecimal sumCurrNetAmt;

    @ApiModelProperty("含税总额")
    BigDecimal sumTaxAmt;

    @ApiModelProperty("记账日期")
    private LocalDateTime finDate;

    @ApiModelProperty("推送WMS状态")
    private String wmsStatus;

    @ApiModelProperty("推送WMS状态")
    private String wmsStatusName;

    @ApiModelProperty("推送WMS时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime wmsTime;

    @ApiModelProperty("接收WMS回传状态")
    private String wmsFeedbackStatus;

    @ApiModelProperty("接收WMS回传状态")
    private String wmsFeedbackStatusName;

    @ApiModelProperty("wms日志")
    private String wmsLog;

    @ApiModelProperty("WMS撤回日志")
    private String wmsCancelLog;

    @ApiModelProperty("WMS撤回时间")
    private LocalDateTime wmsCancelTime;
    @ApiModelProperty("是否需要验收 0:否 1：是")
    private Integer acceptance;
    private String acceptanceName;
    private Boolean qt;

    @ApiModelProperty("第三方平台类型 吉客云 聚水潭 等")
    private String thirdPlatformType;

    @ApiModelProperty("第三方平台唯一标识 兼容id和编号")
    private String thirdPlatformId;

    @ApiModelProperty("第三方平台创建时间")
    private LocalDateTime thirdPlatformCreateTime;
}
