package com.elitesland.pur.dto.gr;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.sys.component.med.BaseModelMedOrderDVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 采购收货单明细(PurGrD)实体类
 *
 * @author zhao_qiao_gong
 * @since 2020-08-05 17:07:27
 */

/**
 * <p>
 * 采购收货单明细
 * </p>
 *
 * @author zhao_qiao_gong
 * @since 2020-08-05 17:07:27
 */
@Data
@ApiModel(value = "pur_gr_d", description = "采购收货单明细")
@EqualsAndHashCode(callSuper = true)
public class PurGrDRespVODTO extends BaseModelMedOrderDVO implements Serializable {
    private static final long serialVersionUID = -69257486513571911L;

    /**
     * 主表ID
     */
    @ApiModelProperty("主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long masId;
    @ApiModelProperty("关联单据编号")
    private String poNo;
    @ApiModelProperty("研发项目")
    private String rdPro;

    @ApiModelProperty("行号")
    private Double lineNo;

    @ApiModelProperty("采购订单明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long poDId;

    @ApiModelProperty("供应商发货单明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ssDId;

    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;
    @ApiModelProperty("商品编码")
    private String itemCode;
    @ApiModelProperty("商品名称")
    private String itemName;
    @ApiModelProperty("商品规格")
    private String itemSpec;
    private String brand;
    @ApiModelProperty("商品品牌")
    private String brandName;
    private String itemCateFullName;

    @ApiModelProperty("最大允差比例")
    private BigDecimal toleranceRatio;
    @ApiModelProperty("收货允差")
    private BigDecimal recvTolerance;

    @ApiModelProperty("订购数量")
    private BigDecimal poQty;

    @ApiModelProperty("开票数量")
    private BigDecimal invoiceQty;

    @ApiModelProperty("订单已收货数量")
    private BigDecimal poAcceptQty;
    @ApiModelProperty("订单已拒收数量")
    private BigDecimal poRejectedQty;

    @ApiModelProperty("可收货数量")
    private BigDecimal ssQty;

    @ApiModelProperty("收货数量")
    private BigDecimal qty;
    @ApiModelProperty("基本单位的收货数量")
    private BigDecimal qty2;

    @ApiModelProperty("拒收数量")
    private BigDecimal rejectQty;

    @ApiModelProperty("申请退货数量")
    private BigDecimal rpoReturnQty;
    @ApiModelProperty("已退货数量")
    private BigDecimal returnedQty;

    @ApiModelProperty("可收货数量")
    private BigDecimal unAcceptQty;

    @ApiModelProperty("收货状态")
    @SysCode(sys = "yst-purc", mod = "RECV_STATUS")
    private String recvStatus;
    private String recvStatusName;

    @ApiModelProperty("对账数量")
    private BigDecimal checkQty;

    @ApiModelProperty("单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;

    @ApiModelProperty("单位2 - 商品主单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom2;
    private String uom2Name;

    @ApiModelProperty("发货单已拒收数量")
    private BigDecimal ssRejectedQty;

    @ApiModelProperty("供应商发货单已收数量")
    private Double ssAcceptQty;

    @ApiModelProperty("订单已取消数量")
    private BigDecimal canceledQty;

    @ApiModelProperty("收货单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String acceptUom;
    private String acceptUomName;

    @ApiModelProperty("已出库数量")
    private BigDecimal shippedQty;

    @ApiModelProperty("发货单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String shipmentUom;
    private String shipmentUomName;
    /**
     * 单位转换率
     */
    @ApiModelProperty("单位转换率")
    private BigDecimal uomRatio;
    /**
     * 保留小数位
     */
    @ApiModelProperty("保留小数位")
    private Integer decimalPlaces;
    /**
     * 税额
     */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
    /**
     * 含税金额
     */
    @ApiModelProperty("含税金额")
    private BigDecimal amt;
    /**
     * 不含税金额
     */
    @ApiModelProperty("不含税金额")
    private BigDecimal netAmt;
    /**
     * 外币含税金额
     */
    @ApiModelProperty("外币含税金额")
    private BigDecimal currAmt;
    /**
     * 外币不含税金额
     */
    @ApiModelProperty("外币不含税金额")
    private BigDecimal currNetAmt;
    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("仓库编码")
    private String whCode;


    @ApiModelProperty("仓库名称")
    private String whName;

    /**
     * 功能区 [UDC]INV:FUNC_TYPE
     */
    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    // @SysCode(sys = "yst-inv", mod = "FUNC_TYPE")
    private String deter2;
    private String deter2Name;
    /**
     * 收货批次
     */
    @ApiModelProperty("收货批次")
    private String lotNo;
    /**
     * 生产日期
     */
    @ApiModelProperty("生产日期")
    private LocalDateTime manuDate;
    /**
     * 过期日期
     */
    @ApiModelProperty("过期日期")
    private LocalDateTime expireDate;
    /**
     * 保质期天数
     */
    @ApiModelProperty("保质期天数")
    private Integer expireDays;
    /**
     * 条码
     */
    @ApiModelProperty("条码")
    private String barcode;

    /**
     * 关联单据类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据类别 [UDC]COM:DOC_CLS")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String relateDocCls;
    private String relateDocClsName;
    /**
     * 关联单据类型
     */
    @ApiModelProperty("关联单据类型")
    private String relateDocType;
    /**
     * 关联单据ID
     */
    @ApiModelProperty("关联单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocId;
    /**
     * 关联单据编号
     */
    @ApiModelProperty("关联单据编号")
    private String relateDocNo;
    /**
     * 关联单据明细ID
     */
    @ApiModelProperty("关联单据明细ID - 采购订单明细")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocDid;
    /**
     * 关联单据行号
     */
    @ApiModelProperty("关联单据行号 - 采购订单行号")
    private Double relateDocLineno;

    @ApiModelProperty("来源单据id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long rootDocId;

    @ApiModelProperty("来源单据编号")
    private String rootDocNo;

    @ApiModelProperty("来源单据明细id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long rootDocDid;

    @ApiModelProperty("来源单据明细行号")
    private Double rootDocLineno;


    @ApiModelProperty("来源单据类别 [UDC]COM:DOC_CLS")
    private String rootDocCls;

    /**
     * 关联单据2类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据2类别 [UDC]COM:DOC_CLS")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String relateDoc2Cls;
    private String relateDoc2ClsName;
    /**
     * 关联单据2类型
     */
    @ApiModelProperty("关联单据2类型")
    private String relateDoc2Type;
    /**
     * 关联单据2ID
     */
    @ApiModelProperty("关联单据2ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDoc2Id;
    /**
     * 关联单据2编号
     */
    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;
    /**
     * 关联单据2明细ID
     */
    @ApiModelProperty("关联单据2明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDoc2Did;
    /**
     * 关联单据2行号
     */
    @ApiModelProperty("关联单据2行号")
    private Double relateDoc2Lineno;

    @ApiModelProperty("品牌")
    private String dbrand;
    String dbrandName;

    @ApiModelProperty("不含税价格")
    private BigDecimal netPrice;

    @ApiModelProperty("含税单价")
    private BigDecimal price;

    @ApiModelProperty("价格本价格")
    private BigDecimal pbPrice;

    @ApiModelProperty("价格本币种")
    private String pbCurr;

    @ApiModelProperty("价格本单位")
    private String pbUom;

    @ApiModelProperty("税率编号")
    private String taxRateNo;

    @ApiModelProperty("外币含不税单价")
    private BigDecimal currNetPrice;

    @ApiModelProperty("外币含税单价")
    private BigDecimal currPrice;

    @ApiModelProperty("币种")
    private String currCode;
    private String currName;

    @ApiModelProperty("汇率")
    private Double currRate;

    @ApiModelProperty("收货单据编号")
    String grNo;

    /**
     * 商品是否启用批次
     */
    @ApiModelProperty("商品是否启用批次")
    private Boolean lotFlag;

    @ApiModelProperty("收货地址国家")
    private String country;

    @ApiModelProperty("收货地址省")
    private String province;

    @ApiModelProperty("收货地址市")
    private String city;

    @ApiModelProperty("收货地址区县")
    private String county;

    @ApiModelProperty("地址")
    private String detailAddr;

    @ApiModelProperty("采购退货登记单已签收数量")
    private BigDecimal confirmQty;

    @ApiModelProperty("库存可供数量")
    private BigDecimal avalQty;

    /**
     * 收货日期
     */
    @ApiModelProperty("收货日期")
    private LocalDateTime recvDate;
    /**
     * 单据状态 [UDC]PUR:GR_STATUS
     */
    @ApiModelProperty("单据状态 [UDC]PUR:GR_STATUS")
    @SysCode(sys = "yst-purc", mod = "GR_STATUS")
    private String docStatus;
    private String docStatusName;

    @ApiModelProperty("入库日期")
    private LocalDateTime storageDate;

    @ApiModelProperty("待收货数量")
    private BigDecimal  leaveReceivedQty;
    @ApiModelProperty("是否为复制数据行")
    private Boolean isCopy;

    @ApiModelProperty("商品库存状态 [UDC:inv]STK_ITM_STATUS")
    @SysCode(sys = "yst-inv", mod = "STK_ITM_STATUS")
    private String stkItmStatus;
    private String stkItmStatusName;

    @ApiModelProperty("对账状态 [UDC:yst-purc]ACCOUNT_STATUS")
    @SysCode(sys = "yst-purc", mod = "ACCOUNT_STATUS")
    private String accountStatus;
    private String accountStatusName;

//    @ApiModelProperty("收货记录")
//    private List<PurGrDLotRespVO> purGrDLotRespVOList;

    @ApiModelProperty(value = "是否管理库存")
    private Boolean manageInvFlag;

    @ApiModelProperty("单位成本")
    private BigDecimal costPrice;

    @ApiModelProperty("储值账户金额")
    private BigDecimal storedAmt;

    @ApiModelProperty("信用账户金额")
    private BigDecimal creditAmt;

    @ApiModelProperty("返利账户金额")
    private BigDecimal rebateAmt;

    @ApiModelProperty("结算含税单价")
    private BigDecimal amortizedPrice;

    @ApiModelProperty("销售含税金额")
    private BigDecimal lastPathSaleAmt;

    @ApiModelProperty("销售含税单价")
    private BigDecimal lastPathSalePrice;

    @ApiModelProperty("表分区字段：月")
    private Integer ym;

    @ApiModelProperty("生产厂家")
    private String manuFactory;
    @ApiModelProperty("生产厂家名")
    private String manuFactoryName;

    @ApiModelProperty("合同ID")
    private Long contractId;
    @ApiModelProperty("合同名称")
    private String contractName;

    @ApiModelProperty(value = "管理复检有效期")
    private Boolean manageRecheckValidityFlag;

    @ApiModelProperty(value = "是否管理批号")
    private Boolean manageLotFlag;

    public String getToleranceRatioStr() {
        if (toleranceRatio != null) {
            return toleranceRatio.toPlainString() + "%"; //以百分号形式显示
        }
        return null;
    }
}
