package com.elitesland.pur.dto.rns;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.sys.component.med.BaseModelMedOrderVO;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;
import java.io.Serial;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/11/3 周一
 */
@Getter
@Setter
public class PurRnsCreateRpcParam implements Serializable {
    @Serial
    private static final long serialVersionUID = 6792389666256223517L;

    @ApiModelProperty(value = "公司ID", required = true)
    private Long ouId;
    private String ouCode;

    @ApiModelProperty("部门ID")
    private Long buId;
    @ApiModelProperty("部门ID")
    private String buCode;

    @ApiModelProperty(value = "采购场景类型", required = true)
    private Long sceneTypeId;
    private String sceneTypeCode;

    @ApiModelProperty(value = "退货人员工ID")
    private Long docEmpId;
    private String docEmpName;

    @ApiModelProperty(value = "供应商ID", required = true)
    private Long suppId;

    @ApiModelProperty(value = "仓库ID", required = true)
    private Long whId;
    private String whCode;
    private String whName;
    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    @SysCode(sys="yst-inv",mod = "FUNC_TYPE")
    private String deter2;
    private String deter2Name;

    @ApiModelProperty("记账币种")
    private String homeCurr;
    @ApiModelProperty("交易币种")
    private String currCode;

    @ApiModelProperty("汇率")
    private BigDecimal currRate;

    @ApiModelProperty("关联单据类别 [UDC]RMA。COM:DOC_CLS")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String relateDocCls;
    private String relateDocClsName;
    @ApiModelProperty("关联单据类型")
    private String relateDocType;
    @ApiModelProperty("关联单据ID")
    private Long relateDocId;
    @ApiModelProperty("关联单据编号")
    private String relateDocNo;

    @ApiModelProperty("关联ID")
    private Long relateId;
    @ApiModelProperty("关联编号")
    private String relateNo;

    @ApiModelProperty("关联2ID")
    private Long relate2Id;
    @ApiModelProperty("关联2编号")
    private String relate2No;

    @ApiModelProperty("流程实例ID")
    private String procInstId;
    @ApiModelProperty("流程实例状态")
    private ProcInstStatus procInstStatus;
    @ApiModelProperty(value = "提交时间")
    private LocalDateTime submitTime;
    @ApiModelProperty("审批时间")
    private LocalDateTime apprTime;

//    @ApiModelProperty("退货详情")
//    private List<PurRnsDSaveVO> purRnsDVOList;

    @ApiModelProperty("国家")
    private String country;
    @ApiModelProperty("省")
    private String province;
    @ApiModelProperty("市")
    private String city;
    @ApiModelProperty("区县")
    private String county;

    @ApiModelProperty("文件服务器编码")
    private String fileCode;

    @ApiModelProperty("项目编码")
    private String projectCode;
    @ApiModelProperty("项目名称")
    private String projectName;

    @ApiModelProperty("结算路径")
    private String pathCode;

    @ApiModelProperty("公司间一致性")
    private Boolean companyConsistentFlag;

    @ApiModelProperty("是否出入库 Y-是  N-否")
    private String es11;

    @ApiModelProperty("付款协议编码")
    private String protocolCode;
    @ApiModelProperty("付款协议名称")
    private String protocolName;
}
