package com.elitesland.pur.dto.rns;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serial;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/11/3 周一
 */
@Getter
@Setter
public class PurRnsCreateRpcParam implements Serializable {
    @Serial
    private static final long serialVersionUID = 6792389666256223517L;

    @ApiModelProperty(value = "公司ID", required = true)
    private Long ouId;
    private String ouCode;

    @ApiModelProperty("部门ID")
    private Long buId;
    @ApiModelProperty("部门编码")
    private String buCode;

    @ApiModelProperty(value = "采购场景类型")
    private Long sceneTypeId;

    @ApiModelProperty(value = "退货人员工ID")
    private Long docEmpId;
    private String docEmpName;

    @ApiModelProperty("单据日期")
    private LocalDateTime docDate;

    @ApiModelProperty(value = "供应商ID", required = true)
    private Long suppId;

    @ApiModelProperty(value = "仓库ID", required = true)
    private Long whId;
    private String whCode;
    @ApiModelProperty("功能区 [UDC]yst-inv:FUNC_TYPE")
    private String deter2;

    @ApiModelProperty("记账币种")
    private String homeCurr;
    @ApiModelProperty("交易币种")
    private String currCode;

    @ApiModelProperty("汇率")
    private BigDecimal currRate;

    @ApiModelProperty("付款协议编码")
    private String protocolCode;

    @ApiModelProperty("关联单据类别 [UDC]RMA。COM:DOC_CLS")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String relateDocCls;
    private String relateDocClsName;
    @ApiModelProperty("关联单据类型")
    private String relateDocType;
    @ApiModelProperty("关联单据ID")
    private Long relateDocId;
    @ApiModelProperty("关联单据编号")
    private String relateDocNo;


//    @ApiModelProperty("退货详情")
//    private List<PurRnsDSaveVO> purRnsDVOList;

    @ApiModelProperty("国家")
    private String country;
    @ApiModelProperty("省")
    private String province;
    @ApiModelProperty("市")
    private String city;
    @ApiModelProperty("区县")
    private String county;

    @ApiModelProperty("项目编码")
    private String projectCode;
    @ApiModelProperty("项目名称")
    private String projectName;

    @ApiModelProperty("结算路径")
    private String pathCode;

    @ApiModelProperty("公司间一致性")
    private Boolean companyConsistentFlag;

    @ApiModelProperty("是否出入库 Y-是  N-否")
    private String es11;
}
