package com.elitesland.pur.dto.supp;

import com.elitescloud.cloudt.common.annotation.SysCode;

import com.elitesland.pur.base.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author feng
 * @program: yst-pur
 * @description: 采购场景
 * @date 2022-03-23 11:20:42
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class PurSceneDTO extends BaseModelVO implements Serializable {

    private static final long serialVersionUID = 2753463554387017127L;
    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;
    /**
     * BUID
     */
    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;
    /**
     * 场景编号
     */
    @ApiModelProperty("场景编号")
    private String sceneCode;
    /**
     * 场景名称
     */
    @ApiModelProperty("场景名称")
    private String sceneName;
    /**
     * 场景状态 [UDC]COM:STATUS_ACTIVEORNO
     */
    @ApiModelProperty("场景状态 [UDC]COM:STATUS_ACTIVEORNO")
    @SysCode(sys = "yst-supp", mod = "STATUS_ACTIVEORNO")
    private String sceneStatus;
    private String sceneStatusName;
    /**
     * 国内国外 [UDC]PUR:DOMAIN_TYPE
     */
    @ApiModelProperty("国内国外 [UDC]PUR:DOMAIN_TYPE")
    @SysCode(sys = "yst-purc", mod = "DOMAIN_TYPE")
    private String es1;
    private String es1Name;
    /**
     * 是否团内 [UDC]ORG:SUPP_TYPE2
     */
    @ApiModelProperty("是否团内 [UDC]PUR:PUR_BUSINESS_TYPE")
    @SysCode(sys = "yst-purc", mod = "PUR_BUSINESS_TYPE")
    private String es2;
    private String es2Name;
    /**
     * 是否免值 [UDC]COM:ZEROVAL_TYPE
     */
    @ApiModelProperty("是否免值 [UDC]COM:ZEROVAL_TYPE")
    @SysCode(sys = "yst-supp", mod = "ZEROVAL_TYPE")
    private String es3;
    private String es3Name;
    /**
     * 来源 [UDC]PUR:PO_GEN_TYPE
     */
    @ApiModelProperty("来源 [UDC]PUR:PO_GEN_TYPE")
    @SysCode(sys = "yst-purc", mod = "PO_GEN_TYPE")
    private String es4;
    private String es4Name;
    /**
     * ES5
     */
    @ApiModelProperty("商品类型 [UDC]PUR:PO_TYPE2")
    @SysCode(sys = "yst-purc", mod = "PO_TYPE2")
    private String es5;
    private StringBuilder es5Name;
    /**
     * ES6
     */
    @ApiModelProperty(value = "0：禁用，1：启用")
    private Integer es6;
    /**
     * ES7
     */
    @ApiModelProperty("业务类型 [UDC]PUR:BUSS_TYPE")
    @SysCode(sys = "yst-purc", mod = "BUSS_TYPE")
    private String es7;
    private String es7Name;
    /**
     * ES8
     */
    @ApiModelProperty("场景类型 [UDC]PUR:SCENE_TYPE")
    @SysCode(sys = "yst-purc", mod = "SCENE_TYPE")
    private String es8;
    private String es8Name;
    /**
     * ES9
     */
    @ApiModelProperty("ES9 团内销售订单类型 [UDC]SAL:SO_TYPE")
    @SysCode(sys = "yst-order", mod = "SO_TYPE")
    private String es9;
    private String es9Name;
    /**
     * ES10
     */
    @ApiModelProperty("ES10")
    private Integer es10;

    @ApiModelProperty("ES11 是否需要出入库 [UDC]PUR:STORAGE_TYPE")
    @SysCode(sys = "yst-purc", mod = "STORAGE_TYPE")
    private String es11;
    private String es11Name;

    @ApiModelProperty("关联采购场景")
    String relateSceneId;
    StringBuilder relateSceneName;

    @ApiModelProperty("对账类型 [UDC]PUR:ACCOUNT_TYPE")
    @SysCode(sys = "yst-purc", mod = "ACCOUNT_TYPE")
    String accountType;
    String accountTypeName;

    /**
     * 能否手开
     */
    @ApiModelProperty("能否手开")
    private Integer ee1;
    /**
     * EE2
     */
    @ApiModelProperty("EE2")
    private Integer ee2;
    /**
     * EE3
     */
    @ApiModelProperty("EE3")
    private Integer ee3;
    /**
     * EE4
     */
    @ApiModelProperty("EE4")
    private Integer ee4;
    /**
     * EE5
     */
    @ApiModelProperty("EE5")
    private Integer ee5;
    /**
     * 订单类型 [UDC]PUR:PO_TYPE
     */
    @ApiModelProperty("订单类型 [UDC]PUR:PO_TYPE")
    private String poType;
    /**
     * 是否启用审批
     */
    @ApiModelProperty("是否启用审批")
    private Integer apprFlag;
    /**
     * 是否检查MOQ
     */
    @ApiModelProperty("是否检查MOQ")
    private Integer moqFlag;
    /**
     * 生效时间
     */
    @ApiModelProperty("生效时间")
    private LocalDateTime validFrom;
    /**
     * 失效时间
     */
    @ApiModelProperty("失效时间")
    private LocalDateTime validTo;
    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;
    /**
     * 记录创建者ID
     */
    @ApiModelProperty("记录创建者ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;

    @ApiModelProperty("记录创建者")
    private String creator;

    /**
     * 记录创建时间
     */
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;
    /**
     * 记录最后更新者ID
     */
    @ApiModelProperty("记录最后更新者ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long modifyUserId;

    @ApiModelProperty("记录最后更新者")
    private String updater;

    /**
     * 记录最后更新时间
     */
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;
    /**
     * 逻辑删除，0：未删除，1：已删除
     */
    @ApiModelProperty("逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;
    /**
     * 版本信息，前端不用传
     */
    @ApiModelProperty("版本信息，前端不用传")
    private Integer auditDataVersion;

    @ApiModelProperty("是否需要验收 0：否 1是")
    private Integer acceptance;
}
