package com.elitesland.pur.dto.rns;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.sys.component.med.BaseModelMedOrderDVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serial;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/11/4 周二
 */
@Getter
@Setter
public class PurRnsDCreateRpcParam extends BaseModelMedOrderDVO {
    @Serial
    private static final long serialVersionUID = 1202743800548948559L;

    @ApiModelProperty(value = "商品ID", required = true)
    private Long itemId;
    @ApiModelProperty("商品编码")
    private String itemCode;
    @ApiModelProperty("商品名称")
    private String itemName;
    @ApiModelProperty("品项规格")
    private String itemSpec;

    @ApiModelProperty(value = "批次号", required = true)
    private String lotNo;

    @ApiModelProperty("库存可供量")
    private BigDecimal avalQty;

    @ApiModelProperty("可退数量")
    private BigDecimal returnableQty;

    @ApiModelProperty("数量")
    private BigDecimal qty;

    @ApiModelProperty("基本单位数量")
    private BigDecimal qty2;

    @ApiModelProperty("采购订单数量")
    private BigDecimal poQty;

    @ApiModelProperty("已付款数量")
    private BigDecimal amtQty;

    @ApiModelProperty("已收数量")
    private BigDecimal acceptQty;

    @ApiModelProperty("已退数量")
    private BigDecimal returnedQty;

    @ApiModelProperty("退货数量")
    private BigDecimal returnQty;

    @ApiModelProperty("已签收数量")
    private BigDecimal confirmQty;

    @ApiModelProperty("单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;

    @ApiModelProperty("基本单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom2;
    private String uom2Name;

    @ApiModelProperty("单位转换率")
    private BigDecimal uomRatio;

    @ApiModelProperty("保留小数位")
    private Integer decimalPlaces;

    @ApiModelProperty("不含税价格")
    private BigDecimal netPrice;
    @ApiModelProperty("含税单价")
    private BigDecimal price;

    @ApiModelProperty("未税单价(外币）")
    private BigDecimal currNetPrice;
    @ApiModelProperty("含税单价(外币")
    private BigDecimal currPrice;

    @ApiModelProperty("价格本价格")
    private BigDecimal pbPrice;
    @ApiModelProperty("价格本币种")
    private String pbCurr;
    @ApiModelProperty("价格本单位")
    private String pbUom;

    @ApiModelProperty("税率编号")
    private String taxRateNo;
    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("含税金额")
    private BigDecimal amt;
    @ApiModelProperty("不含税金额")
    private BigDecimal netAmt;

    @ApiModelProperty("外币含税金额")
    private BigDecimal currAmt;
    @ApiModelProperty("外币不含税金额")
    private BigDecimal currNetAmt;

    @ApiModelProperty("币种")
    private String currCode;
    private String currName;
    @ApiModelProperty("汇率")
    private BigDecimal currRate;

    @ApiModelProperty("退货原因码 [UDC]PUR:RNS_REASON")
    @SysCode(sys = "yst-supp", mod = "REASON_CODE")
    private String rnsReason;
    private String rnsReasonName;

    @ApiModelProperty("关联单据类别 [UDC]COM:DOC_CLS")
    private String relateDocCls;
    @ApiModelProperty("关联单据类型")
    private String relateDocType;
    @ApiModelProperty("关联单据ID")
    private Long relateDocId;
    @ApiModelProperty("关联单据编号")
    private String relateDocNo;
    @ApiModelProperty("关联单据明细ID")
    private Long relateDocDid;
    @ApiModelProperty("关联单据行号")
    private BigDecimal relateDocLineno;

    @ApiModelProperty("关联单据2类别 [UDC]COM:DOC_CLS")
    private String relateDoc2Cls;
    @ApiModelProperty("关联单据2类型")
    private String relateDoc2Type;
    @ApiModelProperty("关联单据2ID")
    private Long relateDoc2Id;
    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;
    @ApiModelProperty("关联单据2明细ID")
    private Long relateDoc2Did;
    @ApiModelProperty("关联单据2行号")
    private BigDecimal relateDoc2Lineno;

    @ApiModelProperty("来源单据类别[UDC]COM:DOC_CLS]")
    private String rootDocCls;
    @ApiModelProperty("来源单据类型")
    private  String rootDocType;
    @ApiModelProperty("来源单据ID")
    private Long rootDocId;
    @ApiModelProperty("来源单据编号")
    private String rootDocNo;
    @ApiModelProperty("来源单据明细ID")
    private Long rootDocDid;
    @ApiModelProperty("来源单据行号")
    private Integer rootDocLineNo;

    @ApiModelProperty("关联单据3类别 [UDC]COM:DOC_CLS")
    private String relateDoc3Cls;
    @ApiModelProperty("关联单据3类型")
    private String relateDoc3Type;
    @ApiModelProperty("关联单据3ID")
    private Long relateDoc3Id;
    @ApiModelProperty("关联单据3编号")
    private String relateDoc3No;
    @ApiModelProperty("关联单据3明细ID")
    private Long relateDoc3Did;
    @ApiModelProperty("关联单据3行号")
    private BigDecimal relateDoc3Lineno;

    @ApiModelProperty("条码")
    private String barcode;

    @ApiModelProperty("品牌")
    private String dbrand;
    private String dbrandName;

    @ApiModelProperty("是否启用批次")
    private Boolean lotFlag;
    @ApiModelProperty(value = "是否管理库存")
    private Boolean manageInvFlag;

    @ApiModelProperty("生产日期")
    private LocalDateTime manuDate;
    @ApiModelProperty("过期日期")
    private LocalDateTime expireDate;
    @ApiModelProperty("保质期天数")
    private Integer expireDays;

    @ApiModelProperty("商品库存状态 [UDC:inv]STK_ITM_STATUS")
    private String stkItmStatus;

    @ApiModelProperty("生产厂家")
    private String manuFactory;
    @ApiModelProperty("生产厂家名")
    private String manuFactoryName;

    @ApiModelProperty("结算含税单价")
    private BigDecimal amortizedPrice;
}
