package com.elitesland.pur.provider;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.pur.Application;
import com.elitesland.pur.dto.ss.PurSsDTO;
import com.elitesland.pur.dto.ss.PurSsRespVODTO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + PurSsProvider.PATH)
public interface PurSsProvider {
    String PATH = "/purSs";

    @PostMapping("/updateCarrierInfo")
    ApiResult<Void> updateCarrierInfo(@RequestBody PurSsDTO param);

    @PostMapping("/updateIsCarrige")
    ApiResult<Void> updateIsCarrige(@RequestBody PurSsDTO param);

    @GetMapping("/findSsByDocNoOne")
    @ApiOperation("查询供应商发货单详情")
    ApiResult<PurSsRespVODTO> findSsByDocNoOne(@RequestBody String docNo);

    @ApiOperation("取消供应商发货单详情")
    @GetMapping(value = "/cancelByDocNo")
    ApiResult<String> cancelByDocNo(@RequestParam("docNo") String docNo);

    @ApiOperation("根据关联单据号取消供应商发货单详情")
    @GetMapping(value = "/cancelByRelateDocNo")
    ApiResult<String> cancelByRelateDocNo(@RequestParam("relateDocNo") String relateDocNo);
}
