package com.elitesland.pur.provider;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.pur.Application;
import com.elitesland.pur.dto.rns.*;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + PurRnsProvider.PATH)
public interface PurRnsProvider {
    String PATH = "/purRns";

    @ApiOperation(value = "创建采购退货申请单")
    @PostMapping(value = "/create")
    ApiResult<Long> create(@RequestBody PurRnsCreateRpcParam createRpcParam);

    @ApiOperation(value = "删除采购退货申请单")
    @PostMapping(value = "/delete")
    ApiResult<Long> delete(@RequestParam("id") Long id);

    @PostMapping("/submitRns")
    ApiResult<PurRnsSaveRpcResult> submitRns(@RequestBody PurRnsSaveRpcParam purRnsSaveRpcParam);

    @GetMapping("/findById")
    ApiResult<PurRnsRpcDTO> findById(@RequestParam("id") Long id);

    @GetMapping("/findByIdSimple")
    ApiResult<PurRnsRpcDTO> findByIdSimple(@RequestParam("id") Long id);

    @GetMapping("/findRgrByRns")
    ApiResult<PurRnsRgrRpcDTO> findRgrByRns(@RequestParam("id") Long id);

    /**
     * 根据退货申请单ID查询
     * @param ids
     * @return 审批中单据的ID集合
     */
    @PostMapping("/findApproving")
    ApiResult<List<Long>> findApproving(@RequestBody List<Long> ids);

    @PostMapping("/abort")
    ApiResult abort(@RequestParam("id") Long id);

    @ApiOperation(value = "发货")
    @PostMapping("/delivery")
    ApiResult<Long> delivery(@RequestBody PurRnsDeliveryRpcDTO deliveryRpcDTO);

    @ApiOperation(value = "确认出库")
    @PostMapping("/confirmInvOdo")
    ApiResult<Long> confirmInvOdo(@RequestBody PurRnsConfirmRpcDTO confirmRpcDTO);

}
