package com.elitesland.pur.dto.supp;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author jeesie
 * @description:
 * @datetime 2025年 04月 15日 17:39
 * @version: 1.0
 */
@Data
@ApiModel(value = "PurSuppTaxRpcParam", description = "供应商商品税率查询条件")
public class PurSuppTaxRpcParam implements Serializable {

    @ApiModelProperty(value = "供应商id")
    @JsonSerialize(using = ToStringSerializer.class)
    @NotNull
    private Long suppId;

    @ApiModelProperty(value = "商品id集合")
    private List<Long> itemIds;
}
