package com.elitesland.pur.dto.supp;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.sys.component.med.BaseModelMedOrderVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2022/05/23
 * @Version 1.0
 * @Content:
 */
@Data
public class PurSsRpcParam extends BaseModelMedOrderVO implements Serializable {
    @Serial
    private static final long serialVersionUID = -7339784131051316737L;

    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;
    /**
     * BUID
     */
    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    /**
     * 单据编号
     */
    @ApiModelProperty("单据编号")
    private String docNo;
    /**
     * 单据类型 [UDC]PUR:SS_TYPE
     */
    @ApiModelProperty("单据类型 [UDC]PUR:SS_TYPE")
    private String docType;
    /**
     * 单据状态 [UDC]PUR:SS_STATUS
     */
    @ApiModelProperty("单据状态 [UDC]PUR:SS_STATUS")
    private String docStatus;
    /**
     * 收货总数
     */
    @ApiModelProperty("收货总数")
    private BigDecimal qty;


    /**
     * 收货总数
     */
    @ApiModelProperty("收货总数")
    private BigDecimal acceptQty;

    @ApiModelProperty("拒收总数")
    private BigDecimal rejectedQty;

    /**
     * 发货日期
     */
    @ApiModelProperty("发货日期")
    private LocalDateTime shipmentDate;
    /**
     * 采购订单ID
     */
    @ApiModelProperty("采购订单ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long poId;
    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;

    @ApiModelProperty("供应商编码")
    private String suppCode;
    /**
     * 供应商发货单号
     */
    @ApiModelProperty("供应商发货单号")
    private String suppDocNo;
    /**
     * 越库标识
     */
    @ApiModelProperty("越库标识")
    private Integer crosswhFlag;
    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("销售发货仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long saleWhId;
    /**
     * 温层 [UDC]INV:TEMP_TYPE
     */
    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    private String deter1;
    /**
     * 功能区 [UDC]INV:FUNC_TYPE
     */
    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private String deter2;
    /**
     * 客户标识
     */
    @ApiModelProperty("客户标识")
    private String deter3;
    /**
     * 限定4
     */
    @ApiModelProperty("限定4")
    private String deter4;

    private Boolean groupFlag;

    /**
     * 限定5
     */
    @ApiModelProperty("限定5")
    private String deter5;
    /**
     * 限定6
     */
    @ApiModelProperty("限定6")
    private String deter6;
    /**
     * 限定7
     */
    @ApiModelProperty("限定7")
    private String deter7;
    /**
     * 限定8
     */
    @ApiModelProperty("限定8")
    private String deter8;
    /**
     * 库位
     */
    @ApiModelProperty("库位")
    private String whLoc;
    /**
     * 货位
     */
    @ApiModelProperty("货位")
    private String whPosi;
    /**
     * 预计到货日期
     */
    @ApiModelProperty("预计到货日期")
    private LocalDateTime etaDate;
    /**
     * 发运联系人
     */
    @ApiModelProperty("发运联系人")
    private String shipmentContactName;

    /**
     * 发货人
     */
    @ApiModelProperty("发货人员Id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long shipmentEmpId;
    /**
     * 发运联系电话
     */
    @ApiModelProperty("发运联系电话")
    private String shipmentContactTel;

    @ApiModelProperty("发运国家")
    private String shipmentCountry;
    @ApiModelProperty("发运国家-名称")
    private String shipmentCountryName;
    @ApiModelProperty("省")
    private String shipmentProvince;
    @ApiModelProperty("省-名称")
    private String shipmentProvinceName;
    @ApiModelProperty("市")
    private String shipmentCity;
    @ApiModelProperty("市-名称")
    private String shipmentCityName;
    @ApiModelProperty("区")
    private String shipmentCounty;
    @ApiModelProperty("区-名称")
    private String shipmentCountyName;
    @ApiModelProperty("详细地址")
    private String shipmentDetailaddr;

    @ApiModelProperty("是否创建配送单")
    private Boolean carriageFlag  ;

    /**
     * 拒收原因
     */
    @ApiModelProperty("拒收原因")
    private String rejectReason;
    /**
     * 拒收时间
     */
    @ApiModelProperty("拒收时间")
    private LocalDateTime rejectTime;
    /**
     * 根ID
     */
    @ApiModelProperty("根ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long rootId;

    @ApiModelProperty("来源单据id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long rootDocId;

    @ApiModelProperty("来源单据编号")
    private String rootDocNo;

    @ApiModelProperty("来源单据类别")
    private String rootDocCls;

    @ApiModelProperty("关联单据类型")
    private String rootDocType;

    @ApiModelProperty("外部单据id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long outerId;


    @ApiModelProperty("外部单据公司")
    private String outerOu;

    @ApiModelProperty("外部单据类型")
    private String outerType;

    @ApiModelProperty("外部单据编号")
    private String outerNo;

    /**
     * 关联单据类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据类别 [UDC]COM:DOC_CLS")
    private String relateDocCls;
    /**
     * 关联单据类型
     */
    @ApiModelProperty("关联单据类型")
    private String relateDocType;
    /**
     * 关联单据ID
     */
    @ApiModelProperty("关联单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocId;
    /**
     * 关联单据编号
     */
    @ApiModelProperty("关联单据编号")
    private String relateDocNo;
    /**
     * 关联单据2类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据2类别 [UDC]COM:DOC_CLS")
    private String relateDoc2Cls;
    /**
     * 关联单据2类型
     */
    @ApiModelProperty("关联单据2类型")
    private String relateDoc2Type;
    /**
     * 关联单据2ID
     */
    @ApiModelProperty("关联单据2ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDoc2Id;
    /**
     * 关联单据2编号
     */
    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;
    /**
     * 关联ID
     */
    @ApiModelProperty("关联ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateId;
    /**
     * 关联编号
     */
    @ApiModelProperty("关联编号")
    private String relateNo;
    /**
     * 关联2ID
     */
    @ApiModelProperty("关联2ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relate2Id;
    /**
     * 关联2编号
     */
    @ApiModelProperty("关联2编号")
    private String relate2No;
    /**
     * ES1
     */
    @ApiModelProperty("ES1")
    private String es1;
    /**
     * ES2
     */
    @ApiModelProperty("ES2")
    private String es2;
    /**
     * ES3
     */
    @ApiModelProperty("ES3")
    private String es3;
    /**
     * ES4
     */
    @ApiModelProperty("ES4")
    private String es4;
    /**
     * ES5
     */
    @ApiModelProperty("ES5")
    private String es5;

    @ApiModelProperty("收货地址")
    private String recvAddr;

    @ApiModelProperty("本币币种")
    private String homeCurr;

    @ApiModelProperty("币种")
    private String currCode;

    @ApiModelProperty("汇率")
    private BigDecimal currRate;

    @ApiModelProperty("是否含税")
    private Integer taxInclFlag;

    @ApiModelProperty("税码")
    private String taxCode;

    @ApiModelProperty("税率编号")
    private String taxRateNo;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("含税总金额")
    private BigDecimal amt;

    @ApiModelProperty("未税总金额")
    private BigDecimal netAmt;

    @ApiModelProperty("外币不含税金额")
    private BigDecimal currNetAmt;

    @ApiModelProperty("外币含税金额")
    private BigDecimal currAmt;

    @ApiModelProperty("收货人名称")
    private String recvEmpName;

    @ApiModelProperty("收货人ID")
    private Long recvEmpId;

    @ApiModelProperty("收货人ID列表")
    private List<Long> recvEmpIds;

    @ApiModelProperty("仓库联系人电话")
    private String tel;

    @ApiModelProperty("收货地址国家")
    private String country;

    @ApiModelProperty("收货地址省")
    private String province;

    @ApiModelProperty("收货地址市")
    private String city;

    @ApiModelProperty("收货地址区县")
    private String county;

    @ApiModelProperty("收货地址")
    private String detailAddr;


    /**
     * 逻辑删除，0：无接口，1：有接口
     */
    @ApiModelProperty("逻辑删除，0：无接口，1：有接口")
    private Integer intfFlag;

    @ApiModelProperty("快递公司编号")
    private String logisticsOuCode;

    @ApiModelProperty("物流单号")
    private String logisticsDocNo;

    @ApiModelProperty("车号")
    private String carNumber;

    @ApiModelProperty("司机")
    private String driver;

    @ApiModelProperty("司机电话")
    private String driverPhone;

    @ApiModelProperty("包装数量")
    private String packingQty;

    @ApiModelProperty("总重量")
    private String totalWeight;

    @ApiModelProperty("物流备注")
    private String logisticsRemark;

    @ApiModelProperty("仓库联系人")
    private String whContactName;
    @ApiModelProperty("供应商发货单详情")
    private List<PurSsDRpcParam> purSsDRpcParamList;

    @ApiModelProperty("运输方式 [UDC]COM:TP_TYPE")
    private String transType;

    @ApiModelProperty("出货方式")
    private String sellMethod;

    @ApiModelProperty("越库标识 true=是，false=否，默认值为false")
    private Boolean overStockFlag;

    @ApiModelProperty("客商ID")
    private Long enterpriseId;
    @ApiModelProperty("客商编码")
    private String enterpriseCode;
    @ApiModelProperty("客商名称")
    private String enterpriseName;
    @ApiModelProperty("客商客商类型")
    @SysCode(
            sys = "yst-purc",
            mod = "ENTERPRISE_TYPE"
    )
    private String enterpriseType;
    @ApiModelProperty("客商客商类型名称")
    private String enterpriseTypeName;

    @ApiModelProperty(value = "是否需要验收", notes = "0-否、1-是")
    private Integer acceptance;
    @ApiModelProperty(value = "是否免检", notes = "true：免检, false：需要质检")
    private Boolean qt;
    @ApiModelProperty("采购场景ID")
    private Long sceneTypeId;
    @ApiModelProperty("采购场景编码")
    private String sceneTypeCode;
}
