package com.elitesland.pur.dto.rns;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
@ApiModel(value = "PurRnsSaveRpcResult", description = "退货申请保存结果")
public class PurRnsSaveRpcResult implements Serializable {

    private static final long serialVersionUID = 1778196094175766334L;

    @ApiModelProperty("退货申请单id")
    private Long id;

    @ApiModelProperty("退货申请单单号")
    private String docNo;

    @ApiModelProperty("商品集合")
    private List<OrderItem> items;

    @Data
    public static class OrderItem implements Serializable {
        @ApiModelProperty("业务单明细id")
        private Long did;
        @ApiModelProperty("业务单据明细发货数量")
        private BigDecimal qty;
        @ApiModelProperty("商品id")
        private Long itemId;
        private Long relateDocDid;
    }
}
