package com.elitesland.pur.dto.gr;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(description = "采购收货单")
public class PurGrRpcDTO implements Serializable {

    private static final long serialVersionUID = -9066194839868175002L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("ID")
    private Long id;

    @ApiModelProperty("单号")
    private String docNo;

    @ApiModelProperty("创建日期")
    private LocalDateTime createTime;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("地址号")
    Long addrNo;

    @ApiModelProperty("承运商")
    private String carrier;

    @ApiModelProperty("配送方式")
    private String deliverMethod;

    @ApiModelProperty("物流单号")
    private String logisDocNo;

    @ApiModelProperty("收货仓库")
    private Long toWhId;

    @ApiModelProperty("功能区")
    private String deter2;

    @ApiModelProperty("发货供应商")
    private Long suppId;

    @ApiModelProperty("发货供应商")
    private String suppCode;

    @ApiModelProperty("发货供应商")
    private String suppName;

    @ApiModelProperty("状态")
    private String docStatus;
    @ApiModelProperty("采购订单ID")
    private Long poId;

    @ApiModelProperty("入库单号")
    private String invIdoDocNo;

    @ApiModelProperty("来源单据类别 [UDC]yst-supp:DOC_CLS")
    @SysCode(
            sys = "yst-supp",
            mod = "DOC_CLS"
    )
    private String rootDocCls;
    private String rootDocClsName;
    @ApiModelProperty("来源单据类型")
    private String rootDocType;
    @ApiModelProperty("来源单据Id")
    private Long rootDocId;
    @ApiModelProperty("来源单据编号")
    private String rootDocNo;
    @ApiModelProperty("关联单据类型")
    private String relateDocType;
    @ApiModelProperty("关联单据类别 默认入库单 [UDC] yst-inv:INV_DOC_CLS")
    private String relateDocCls;
    @ApiModelProperty("关联单据ID")
    private Long relateDocId;
    @ApiModelProperty("关联单据编号")
    private String relateDocNo;
    @ApiModelProperty("关联单据2类别 [UDC]yst-supp:DOC_CLS")
    @SysCode(
            sys = "yst-supp",
            mod = "DOC_CLS"
    )
    private String relateDoc2Cls;
    private String relateDoc2ClsName;
    @ApiModelProperty("关联单据2类型")
    private String relateDoc2Type;
    @ApiModelProperty("关联单据2ID")
    private Long relateDoc2Id;
    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;
    @ApiModelProperty("客商ID")
    private Long enterpriseId;
    @ApiModelProperty("客商编码")
    private String enterpriseCode;
    @ApiModelProperty("客商名称")
    private String enterpriseName;

    private List<PurGrDetailRpcDTO> rpcDTOS;
}