package com.elitesland.pur.provider;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.pur.Application;
import com.elitesland.pur.dto.gr.*;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Optional;

/**
 * 采购收货单RPC接口
 *
 * @author chaofeng.xia
 * @date 2023/10/8 9:35
 */
@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + PurGrProvider.PATH)
public interface PurGrProvider {
    String PATH = "/purGr";


    /**
     * 跨公司交易，越库生单
     * @param purGrRpcSaveDTO 入库单信息
     * @return 入库单id
     */
    @PostMapping("/createByCrossCompany")
    ApiResult<Long> createByCrossCompany(@RequestBody PurGrRpcSaveDTO purGrRpcSaveDTO);

    /**
     * 确认采购收货单(采购入库)
     *
     * @param purGrRpcSaveDTO 入库单信息
     * @return 入库单id
     */
    @PostMapping("/confirmPurGr")
    ApiResult<Long> confirmPurGr(@RequestBody PurGrRpcSaveDTO purGrRpcSaveDTO);

    /**
     * 分页查询采购收货单信息
     *
     * @param paramVO 分类查询、分页和排序对象
     * @return 分页结果集
     */
    @GetMapping("/search")
    PagingVO<PurGrPageRpcDTO> search(@RequestBody PurGrRpcParamVO paramVO);

    /**
     * 采购收货单信息
     *
     * @param paramVO 筛选
     * @return 分页结果集
     */
    @GetMapping("/listSimple")
    List<PurGrPageRpcDTO> listSimple(@RequestBody PurGrRpcParamVO paramVO);

    @GetMapping("/findById")
    ApiResult<PurGrRpcDTO> findById(@RequestParam("id") Long id);

    @GetMapping("/findByIdSimple")
    ApiResult<PurGrRpcDTO> findByIdSimple(@RequestParam("id") Long id);

    /**
     * 采购收货单部分收货接口
     *
     * @param purGrConfirmRpcDTO 采购收货单信息
     * @return 采购收货单ID
     */
    @PostMapping("/partConfirmPurGr")
    ApiResult<Long> partConfirmPurGr(@RequestBody PurGrConfirmRpcDTO purGrConfirmRpcDTO);

    @GetMapping("/needQt")
    ApiResult<Boolean> needQt(@RequestParam("id") Long id);


    /**
     * 采购出/入库成本回写
     *
     * @param costRpcDTOList 采购出/入库成本明细
     * @return 结果
     */
    @PostMapping("/cost")
    ApiResult<Object> grCost(@RequestBody List<PurGrDetailCostRpcDTO> costRpcDTOList);

    @GetMapping("/findPurGrSuppByIds")
    ApiResult<List<PurGrRpcDTO>> findPurGrSuppByIds(@RequestParam("id") List<Long> ids);

    @GetMapping("/findAllByRelateDoc2No")
    ApiResult<List<String>> findAllByRelate2DocNo(@RequestParam("relateDoc2No") String relateDoc2No, @RequestParam("relateDoc2Cls") String relateDoc2Cls);

    @PostMapping("/batchSubmit")
    @ApiOperation("收货确认")
    ApiResult<List<Long>> batchSubmitPurGr(@RequestParam("id") List<Long> ids);

    @PostMapping("/createPurGr")
    @ApiOperation("收货单保存-原生前端API接口-医药版本新增-库存域wms回调使用")
    ApiResult<Long> createPurGr(@RequestBody PurGrSaveVODTO createParam);

    @GetMapping("/findIdPurGr")
    @ApiOperation("收货单查询-原生前端API接口-医药版本新增-库存域wms回调使用")
    ApiResult<PurGrRespVODTO> findIdPurGr(@RequestParam("id") Long id);
}
