package com.elitesland.pur.dto.supp;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author liuqi
 * @date 2020/7/7
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel("地址号申请的资质信息")
public class PurAddrApplyQualifyRpcSaveVO extends CustomFieldBaseModelVo implements Serializable {

    @ApiModelProperty("证照(资质文件)编号")
    String qualifyNo;

    @ApiModelProperty("证照(资质)类型 :[UDC]ORG:ADDR_QUALIFY_TYPE")
    String qualifyType;
    @ApiModelProperty("资质类型名称")
    String qualifyTypeName;

    @ApiModelProperty("资质证照状态 [UDC]COM:STATUS_ACTIVEORNO")
    String qualifyStatus;
    @ApiModelProperty("资质证照状态")
    String qualifyStatusName;

    @ApiModelProperty("生效时间")
    LocalDateTime validFrom;

    @ApiModelProperty("失效时间")
    LocalDateTime validTo;

    @ApiModelProperty("资质文件名称")
    String qualifyFileName;

    @ApiModelProperty("资质文件编号(上传后系统生成的编号)")
    String qualifyFileCode;

    @ApiModelProperty("主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long masId;

    @ApiModelProperty("行号")
    Integer lineNo;

    @ApiModelProperty("主表业务类型")
    String masDocCls;

    /**
     * 唯一编号ID
     */
    @ApiModelProperty("唯一编号ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("数据来源")
    private String dataSource;
}
