package com.elitesland.pur.dto.rns;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serial;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/11/3 周一
 */
@Getter
@Setter
public class PurRnsCreateRpcParam implements Serializable {
    @Serial
    private static final long serialVersionUID = 6792389666256223517L;

    @ApiModelProperty(value = "是否自动提交", notes = "默认false")
    private Boolean autoSubmit;

    @ApiModelProperty(value = "是否自动审批通过", notes = "默认false")
    private Boolean autoApproved;

    @ApiModelProperty(value = "公司ID", required = true)
    private Long ouId;
    private String ouCode;

    @ApiModelProperty("部门ID")
    private Long buId;
    @ApiModelProperty("部门编码")
    private String buCode;

    @ApiModelProperty(value = "采购场景类型")
    private Long sceneTypeId;

    @ApiModelProperty(value = "退货人员工ID")
    private Long docEmpId;
    private String docEmpName;

    @ApiModelProperty(value = "单据日期")
    private LocalDateTime docDate;

    @ApiModelProperty(value = "供应商ID", required = true)
    private Long suppId;
    @ApiModelProperty("供应商联系人")
    private String suppContactName;
    @ApiModelProperty("供应商联系电话")
    private String suppContactTel;
    @ApiModelProperty("供应商联系人邮箱")
    private String suppContactEmail;
    @ApiModelProperty("国家编码")
    private String country;
    @ApiModelProperty("省编码")
    private String province;
    @ApiModelProperty("市编码")
    private String city;
    @ApiModelProperty("区县编码")
    private String county;
    @ApiModelProperty("退货详细地址")
    private String returnAddr;

    @ApiModelProperty(value = "仓库ID", required = true)
    private Long whId;
    private String whCode;
    @ApiModelProperty("功能区 [UDC]yst-inv:FUNC_TYPE")
    private String deter2;

    @ApiModelProperty("记账币种")
    private String homeCurr;
    @ApiModelProperty("交易币种")
    private String currCode;

    @ApiModelProperty("汇率")
    private BigDecimal currRate;

    @ApiModelProperty(value = "付款协议编码", required = true)
    private String protocolCode;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty(value = "关联单据类别 [UDC]yst-supp:DOC_CLS", required = true)
    private String relateDocCls;
    @ApiModelProperty("关联单据类型")
    private String relateDocType;
    @ApiModelProperty(value = "关联单据ID", required = true)
    private Long relateDocId;
    @ApiModelProperty(value = "关联单据编号", required = true)
    private String relateDocNo;

    @ApiModelProperty("来源单据类别[UDC]COM:DOC_CLS]")
    private String rootDocCls;
    @ApiModelProperty("来源单据类型")
    private  String rootDocType;
    @ApiModelProperty("来源单据ID")
    private Long rootDocId;
    @ApiModelProperty("来源单据编号")
    private String rootDocNo;

    @ApiModelProperty(value = "关联单据类别 [UDC]yst-supp:DOC_CLS")
    private String relateDoc2Cls;
    @ApiModelProperty("关联单据类型")
    private String relateDoc2Type;
    @ApiModelProperty(value = "关联单据ID")
    private Long relateDoc2Id;
    @ApiModelProperty(value = "关联单据编号")
    private String relateDoc2No;

    @ApiModelProperty(value = "关联单据类别 [UDC]yst-supp:DOC_CLS")
    private String relateDoc3Cls;
    @ApiModelProperty("关联单据类型")
    private String relateDoc3Type;
    @ApiModelProperty(value = "关联单据ID")
    private Long relateDoc3Id;
    @ApiModelProperty(value = "关联单据编号")
    private String relateDoc3No;

    @ApiModelProperty(value = "退货明细列表", required = true)
    private List<PurRnsDCreateRpcParam> purRnsDVOList;
}
