package com.elitesland.pur.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2021/06/23
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "purPriceBaseDTO", description = "采购价格DTO基础信息出参对象")
public class PurPriceBaseDTO implements Serializable {
    private static final long serialVersionUID = 6832979868520657294L;

    @ApiModelProperty("是否有价格：true 有, false 无")
    private Boolean priceFlag;

    @ApiModelProperty("提示信息")
    private String priceMsg;

    @ApiModelProperty("商品ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("从单位")
    private String fromUom;

    @ApiModelProperty("至单位")
    private String toUom;

    @ApiModelProperty("币种")
    private String currCode;

    @ApiModelProperty("含税单价")
    private BigDecimal price;

    @ApiModelProperty("基准价格")
    private BigDecimal pbPrice;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("商品单位转换率")
    private BigDecimal uomRatio;


}
