package com.elitesland.pur.provider;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.pur.Application;
import com.elitesland.pur.dto.PoPayRpcDTO;
import com.elitesland.pur.dto.po.PurPayOrderPaidDTO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @Auther: Mark
 * @Date: 2024/8/29 11:00
 * @Description:
 */
@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + PoPayProvider.PATH)
public interface PoPayProvider {

    String PATH = "/pay";

    /**
     * 支付
     */
    @PostMapping("/pay")
    void pay(@RequestBody PoPayRpcDTO poPayRpcDTO);

    @ApiOperation(value = "采购单预付款的支付回调")
    @PostMapping(value = "/paidForPurPoPayment")
    ApiResult<Long> paidForPurPoPayment(@RequestBody PurPayOrderPaidDTO paidDTO);

    @ApiOperation(value = "采购对账单的支付回调")
    @PostMapping(value = "/paidForPurAccountCheck")
    ApiResult<Long> paidForPurAccountCheck(@RequestBody PurPayOrderPaidDTO paidDTO);
}
