package com.elitesland.pur.provider;


import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.pur.Application;
import com.elitesland.pur.dto.account.PurAccountCheckQtyDTO;
import com.elitesland.pur.dto.account.PurAccountDTO;

import javax.validation.Valid;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;


/**
 * <p>
 * 采购对账单
 * </p>
 *
 * @author tina.he
 * @since 2021-06-07 10:01:49
 */
@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + PurAccountProvider.PATH)
public interface PurAccountProvider {

    String PATH = "/purAccount";

    /**
     * 修改类型
     *
     * @param purAccountDTO
     * @return docNos
     */
    @PostMapping("/updateStatus")
    ApiResult<Void> batchUpdateDocStatus(@RequestBody @Valid PurAccountDTO purAccountDTO);

    /**
     * 回写对账单关联的采购收货单和采购退货单开票数量
     *
     * PurAccountCheckQtyDTO——docNo：对账单编号，必填
     * PurAccountCheckQtyDTO——lineNo：对账单明细行号，必填
     * PurAccountCheckQtyDTO——invoiceQty：增加开票数量传正数，减少开票数量传负数
     *
     * @param purAccountCheckQtyDTOList 对账单明细开票数量
     * @return 结果
     */
    @PostMapping("/addInvoiceQty")
    ApiResult<Void> addInvoiceQty(@RequestBody List<PurAccountCheckQtyDTO> purAccountCheckQtyDTOList);
}
