package com.elitesland.pur.dto.ss;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * @Auther: Mark
 * @Date: 2024/6/18 16:40
 * @Description:
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel("供应商归属公司表")
public class PurSuppOuRespVODTO extends CustomFieldBaseModelVo implements Serializable {
    private static final long serialVersionUID = 1071307516399639526L;

    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    private Long suppId;

    /**
     * 供应商编码
     */
    @ApiModelProperty("供应商编码")
    private String suppCode;

    /**
     * 归属公司ID
     */
    @ApiModelProperty("归属公司ID")
    private Long ouId;

    /**
     * 归属公司编码
     */
    @ApiModelProperty("归属公司编码")
    private String ouCode;

    /**
     * 归属公司名称
     */
    @ApiModelProperty("归属公司名称")
    private String ouName;

    /**
     * 组织id
     */
    @ApiModelProperty("组织id")
    private Long buId;

    /**
     * 组织编号
     */
    @ApiModelProperty("组织编号")
    private String buCode;

    /**
     * 组织名称
     */
    @ApiModelProperty("组织名称")
    private String buName;

    @ApiModelProperty("公司状态")
    @SysCode(sys = "yst-supp", mod = "STATUS_ACTIVEORNO")
    private String ouStatus;
    @ApiModelProperty("公司状态名称")
    private String ouStatusName;
}
