package com.elitesland.pur.dto.rns;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serial;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/11/4 周二
 */
@Getter
@Setter
public class PurRnsDeliveryRpcDTO implements Serializable {
    @Serial
    private static final long serialVersionUID = -2041173789328025339L;

    @ApiModelProperty(value = "采购退货申请单ID")
    private Long rnsId;
    @ApiModelProperty(value = "采购退货申请单号")
    private String rnsDocNo;

    @ApiModelProperty(value = "采购退货申请单明细")
    private List<Detail> detailList;

    @Getter
    @Setter
    public static class Detail implements Serializable {
        @Serial
        private static final long serialVersionUID = -2485561205023983460L;

        @ApiModelProperty(value = "采购退货申请单明细ID")
        private Long rnsDid;

        @ApiModelProperty(value = "实际退货数量")
        private BigDecimal actQty;
    }
}
