package com.elitesland.pur.dto.rns;

import com.elitescloud.cloudt.sys.component.med.BaseModelMedOrderDVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.io.Serial;
import java.math.BigDecimal;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/11/4 周二
 */
@Getter
@Setter
public class PurRnsDCreateRpcParam extends BaseModelMedOrderDVO {
    @Serial
    private static final long serialVersionUID = 1202743800548948559L;

    @ApiModelProperty(value = "商品ID", required = true)
    private Long itemId;
    @ApiModelProperty("商品编码")
    private String itemCode;
    @ApiModelProperty("商品名称")
    private String itemName;
    @ApiModelProperty("品项规格")
    private String itemSpec;

    @ApiModelProperty(value = "批次号", required = true)
    private String lotNo;
    @ApiModelProperty(value = "批次ID", required = true)
    private Long lotId;
    @ApiModelProperty("库存可供量")
    private BigDecimal avalQty;
    @ApiModelProperty("库存状态 [UDC]yst-inv:STK_ITM_STATUS")
    private String stkItmStatus;

    @ApiModelProperty("退货数量")
    private BigDecimal qty;

    @ApiModelProperty("基本单位数量")
    private BigDecimal qty2;

    @ApiModelProperty("单位")
    private String uom;

    @ApiModelProperty("基本单位")
    private String uom2;

    @ApiModelProperty("单位转换率")
    private BigDecimal uomRatio;

    @ApiModelProperty("保留小数位")
    private Integer decimalPlaces;

    @ApiModelProperty("不含税价格")
    private BigDecimal netPrice;
    @ApiModelProperty("含税单价")
    private BigDecimal price;

    @ApiModelProperty("未税单价(外币）")
    private BigDecimal currNetPrice;
    @ApiModelProperty("含税单价(外币")
    private BigDecimal currPrice;

    @ApiModelProperty("税率编号")
    private String taxRateNo;
    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("含税金额")
    private BigDecimal amt;
    @ApiModelProperty("不含税金额")
    private BigDecimal netAmt;

    @ApiModelProperty("外币含税金额")
    private BigDecimal currAmt;
    @ApiModelProperty("外币不含税金额")
    private BigDecimal currNetAmt;

    @ApiModelProperty("退货原因码 [UDC]PUR:RNS_REASON")
    private String rnsReason;

    @ApiModelProperty("关联单据类别 [UDC]COM:DOC_CLS")
    private String relateDocCls;
    @ApiModelProperty("关联单据类型")
    private String relateDocType;
    @ApiModelProperty("关联单据ID")
    private Long relateDocId;
    @ApiModelProperty("关联单据编号")
    private String relateDocNo;
    @ApiModelProperty("关联单据明细ID")
    private Long relateDocDid;
    @ApiModelProperty("关联单据行号")
    private BigDecimal relateDocLineno;

    @ApiModelProperty("来源单据类别[UDC]COM:DOC_CLS]")
    private String rootDocCls;
    @ApiModelProperty("来源单据类型")
    private  String rootDocType;
    @ApiModelProperty("来源单据ID")
    private Long rootDocId;
    @ApiModelProperty("来源单据编号")
    private String rootDocNo;
    @ApiModelProperty("来源单据明细ID")
    private Long rootDocDid;
    @ApiModelProperty("来源单据行号")
    private Integer rootDocLineNo;

    @ApiModelProperty(value = "关联单据类别 [UDC]yst-supp:DOC_CLS")
    private String relateDoc2Cls;
    @ApiModelProperty("关联单据类型")
    private String relateDoc2Type;
    @ApiModelProperty(value = "关联单据ID")
    private Long relateDoc2Id;
    @ApiModelProperty(value = "关联单据编号")
    private String relateDoc2No;
    @ApiModelProperty("关联单据明细ID")
    private Long relateDoc2Did;
    @ApiModelProperty("关联单据行号")
    private BigDecimal relateDoc2Lineno;

    @ApiModelProperty(value = "关联单据类别 [UDC]yst-supp:DOC_CLS")
    private String relateDoc3Cls;
    @ApiModelProperty("关联单据类型")
    private String relateDoc3Type;
    @ApiModelProperty(value = "关联单据ID")
    private Long relateDoc3Id;
    @ApiModelProperty(value = "关联单据编号")
    private String relateDoc3No;
    @ApiModelProperty("关联单据明细ID")
    private Long relateDoc3Did;
    @ApiModelProperty("关联单据行号")
    private BigDecimal relateDoc3Lineno;
}
