package com.elitesland.pur.dto.ss;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.sys.component.med.BaseModelMedOrderDVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;


/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author zhao_qiao_gong
 * @since 2020-08-03 10:59:49
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "pur_ss_d", description = "供应商发货单明细")
public class PurSsDRespVODTO extends BaseModelMedOrderDVO implements Serializable {
    private static final long serialVersionUID = -32641534531217458L;

    @ApiModelProperty("主表ID")
    private Long masId;
    @ApiModelProperty("行号")
    private BigDecimal lineNo;

    @ApiModelProperty("品项ID")
    private Long itemId;
    private String itemSpec;

    @ApiModelProperty("仓库ID")
    private Long whId;
    private String whCode;
    private String whName;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    @SysCode(sys = "yst-inv", mod = "FUNC_TYPE")
    private String deter2;
    @ApiModelProperty("功能区名称")
    private String deter2Name;

    @ApiModelProperty("订购数量")
    private BigDecimal poQty;

    @ApiModelProperty("发货数量")
    private BigDecimal qty;
    private BigDecimal qtySum;

    @ApiModelProperty("基本单位数量")
    private BigDecimal qty2;

    @ApiModelProperty("订单已取消数量")
    private BigDecimal canceledQty;

    @ApiModelProperty("订单已收货数量")
    private BigDecimal poAcceptQty;

    @ApiModelProperty("订单已拒收数量")
    private BigDecimal poRejectedQty;

    @ApiModelProperty("订单可发货数量")
    private BigDecimal acUnshipQty;

    @ApiModelProperty("单位转换率")
    private BigDecimal uomRatio;

    @ApiModelProperty("保留小数位")
    private Integer decimalPlaces;

    @ApiModelProperty("最大允差比例")
    private BigDecimal toleranceRatio;

    @ApiModelProperty("收货允差")
    private BigDecimal recvTolerance;

    @ApiModelProperty("拒收数量")
    private BigDecimal rejectedQty;

    @ApiModelProperty("已收数量")
    private BigDecimal acceptQty;
    private BigDecimal acceptQtySum;

    @ApiModelProperty("采购订单已出库数量")
    private BigDecimal shippedQty;

    @ApiModelProperty("可发货通知数量")
    private BigDecimal avalShipmentQty;

    @ApiModelProperty("已退货数量")
    private BigDecimal returnedQty;

    @ApiModelProperty("实际未收数量")
    private BigDecimal unRecpQty;

    @ApiModelProperty("收货单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String acceptUom;
    private String acceptUomName;

    /**
     * 发货单位
     */
    @ApiModelProperty("发货单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String shipmentUom;
    private String shipmentUomName;
    /**
     * 单位
     */
    @ApiModelProperty("单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;


    @ApiModelProperty("基本单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom2;
    private String uom2Name;
    /**
     * 保质期天数
     */
    @ApiModelProperty("保质期天数")
    private Integer expireDays;
    /**
     * 条码
     */
    @ApiModelProperty("条码")
    private String barcode;

    @ApiModelProperty("来源单据id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long rootDocId;

    @ApiModelProperty("来源单据编号")
    private String rootDocNo;

    @ApiModelProperty("来源单据明细id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long rootDocDid;

    @ApiModelProperty("来源单据明细行号")
    private BigDecimal rootDocLineno;


    @ApiModelProperty("来源单据类别 [UDC]COM:DOC_CLS")
    private String rootDocCls;

    /**
     * 功能区 [UDC]INV:FUNC_TYPE
     */
    @ApiModelProperty("分子公司功能区 [UDC]INV:FUNC_TYPE")
    @SysCode(sys = "yst-inv", mod = "FUNC_TYPE")
    private String rootDocDeter2;
    @ApiModelProperty("分子公司功能区名称")
    private String rootDocDeter2Name;

    /**
     * 关联单据类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据类别 [UDC]COM:DOC_CLS")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String relateDocCls;
    @ApiModelProperty("关联单据类别名称")
    private String relateDocClsName;
    /**
     * 关联单据类型
     */
    @ApiModelProperty("关联单据类型")
    private String relateDocType;
    /**
     * 关联单据ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("关联单据ID")
    private Long relateDocId;
    /**
     * 关联单据编号
     */
    @ApiModelProperty("关联单据编号")
    private String relateDocNo;
    /**
     * 关联单据明细ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("关联单据明细ID")
    private Long relateDocDid;
    /**
     * 关联单据行号
     */
    @ApiModelProperty("关联单据行号")
    private BigDecimal relateDocLineno;
    /**
     * 关联单据2类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据2类别 [UDC]COM:DOC_CLS")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String relateDoc2Cls;
    @ApiModelProperty("关联单据2类别名称")
    private String relateDoc2ClsName;
    /**
     * 关联单据2类型
     */
    @ApiModelProperty("关联单据2类型")
    private String relateDoc2Type;
    /**
     * 关联单据2ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("关联单据2ID")
    private Long relateDoc2Id;
    /**
     * 关联单据2编号
     */
    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;
    /**
     * 关联单据2明细ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("关联单据2明细ID")
    private Long relateDoc2Did;
    /**
     * 关联单据2行号
     */
    @ApiModelProperty("关联单据2行号")
    private BigDecimal relateDoc2Lineno;
    /**
     * ES2
     */
    @ApiModelProperty("ES2")
    private String es2;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;
    /**
     * 记录创建者ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("记录创建者ID")
    private Long createUserId;

    @ApiModelProperty("记录创建者")
    private String creator;

    /**
     * 记录创建时间
     */
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;
    /**
     * 记录最后更新者ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("记录最后更新者ID")
    private Long modifyUserId;

    @ApiModelProperty("记录最后更新者")
    private String updater;
    /**
     * 记录最后更新时间
     */
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;
    /**
     * 逻辑删除，0：未删除，1：已删除
     */
    @ApiModelProperty("逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;
    /**
     * 版本信息，前端不用传
     */
    @ApiModelProperty("版本信息，前端不用传")
    private Integer auditDataVersion;

    @ApiModelProperty("品牌code")
    private String dbrand;

    @ApiModelProperty("不含税价格")
    private BigDecimal netPrice;

    @ApiModelProperty("含税单价")
    private BigDecimal price;

    @ApiModelProperty("价格本价格")
    private BigDecimal pbPrice;

    @ApiModelProperty("价格本币种")
    private String pbCurr;

    @ApiModelProperty("价格本单位")
    private String pbUom;

    @ApiModelProperty("税率编号")
    private String taxRateNo;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("外币含不税单价")
    private BigDecimal currNetPrice;

    @ApiModelProperty("外币含税单价")
    private BigDecimal currPrice;

    @ApiModelProperty("币种")
    private String currCode;

    @ApiModelProperty("汇率")
    private BigDecimal currRate;

    /**
     * 税额
     */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
    /**
     * 含税金额
     */
    @ApiModelProperty("含税金额")
    private BigDecimal amt;
    /**
     * 不含税金额
     */
    @ApiModelProperty("不含税金额")
    private BigDecimal netAmt;
    /**
     * 外币含税金额
     */
    @ApiModelProperty("外币含税金额")
    private BigDecimal currAmt;
    /**
     * 外币不含税金额
     */
    @ApiModelProperty("外币不含税金额")
    private BigDecimal currNetAmt;

    /**
     * 商品是否启用批次
     */
    @ApiModelProperty("商品是否启用批次")
    private Boolean lotFlag;

    @ApiModelProperty("收货日期")
    private LocalDateTime recvDate;

    @ApiModelProperty("商品库存状态 [UDC:inv]STK_ITM_STATUS")
    private String stkItmStatus;

    @ApiModelProperty("供应商发货单编号")
    private String docNo;

    @ApiModelProperty("单据状态 [UDC]PUR:SS_STATUS")
    @SysCode(sys = "yst-purc", mod = "SS_STATUS")
    private String docStatus;
    @ApiModelProperty("单据状态名称")
    private String docStatusName;

    @ApiModelProperty("发货日期")
    private LocalDateTime shipmentDate;

    @ApiModelProperty("PO订单日期")
    private LocalDateTime poDocDate;

    @ApiModelProperty("PO单据状态 [UDC]PUR:PO_STATUS")
    @SysCode(sys = "yst-purc", mod = "PO_STATUS")
    private String poStatus;
    @ApiModelProperty("PO单据状态名称")
    private String poStatusName;

//    @ApiModelProperty("转单明细")
//    private List<PurPrdTransferRespVO> transferRespVOList;

    @ApiModelProperty(value = "是否管理库存")
    private Boolean manageInvFlag;

    @ApiModelProperty("表分区字段：月")
    private Integer ym;

    @ApiModelProperty("销售含税金额")
    private BigDecimal lastPathSaleAmt;

    @ApiModelProperty("销售含税单价")
    private BigDecimal lastPathSalePrice;

    @ApiModelProperty("结算含税单价")
    private BigDecimal amortizedPrice;

    @ApiModelProperty(value = "研发项目")
    private String rdPro;

    @ApiModelProperty(value = "管理复检有效期")
    private Boolean manageRecheckValidityFlag;

    @ApiModelProperty(value = "是否管理批号")
    private Boolean manageLotFlag;

    public String getToleranceRatioStr() {
        if (toleranceRatio != null) {
            return toleranceRatio.stripTrailingZeros().toPlainString() + "%"; //以百分号形式显示
        }
        return null;
    }
}
