package com.elitesland.pur.dto.supp;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serial;
import java.io.Serializable;
import java.util.Set;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/10/23 周四
 */
@Getter
@Setter
public class PurSuppSubRpcQueryParam implements Serializable {
    @Serial
    private static final long serialVersionUID = -8935106126048123719L;

    @ApiModelProperty("供应商ID")
    private Set<Long> ids;
    @ApiModelProperty("供应商编码")
    private Set<String> suppCodes;

    @ApiModelProperty("公司ID")
    private Long ouId;
    private Set<Long> ouIds;

    @ApiModelProperty("供应商类型 [UDC]yst-purc:SUPP_TYPE")
    private Set<String> suppTypes;

    @ApiModelProperty("供应商类别 [UDC]yst-purc:SUPP_TYPE2")
    private Set<String> suppType2s;

    @ApiModelProperty("供应商(企业)性质 [UDC]yst-purc:COMP_PROP")
    private Set<String> compProps;

    @ApiModelProperty("供应商基本类型")
    private Set<String> suppBaseTypes;

    @ApiModelProperty("行业类型 [UDC]yst-purc:INDUS_FLAG")
    private Set<String> indusFlag1s;

    @ApiModelProperty("内部交易公司ID")
    private Set<Long> ouId2s;
    @ApiModelProperty("内部交易公司编码")
    private Set<String> ouCode2s;

    @ApiModelProperty("纳税人识别号")
    private Set<String> taxPayerIds;
    @ApiModelProperty("统一信用代码")
    private Set<String> certNos;

    @ApiModelProperty("ERP供应商编码")
    private Set<String> erpSuppCodes;
}
