package com.elitesland.pur.provider;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.pur.Application;
import com.elitesland.pur.dto.account.PurAccountCheckDtlRpcDTO;
import com.elitesland.pur.dto.account.PurAccountCheckDtlRpcParam;
import com.elitesland.pur.dto.account.PurAccountCheckPaymentApplyUpdateRpcDTO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/07/31
 * @Version 1.0
 * @Content:
 */
@FeignClient(name = Application.NAME, path = Application.PATH + PurAccountCheckDtlProvider.PATH)
@Validated
public interface PurAccountCheckDtlProvider {
    String PATH = "/purAccountCheckDtl";

    @PostMapping("/findSimpleRpcDto")
    @ApiOperation(value = "查询对账单明细")
    ApiResult<List<PurAccountCheckDtlRpcDTO>> findSimpleRpcDtoByParam(@RequestBody PurAccountCheckDtlRpcParam param);

    @PostMapping(value = "/updatePaymentApply")
    @ApiOperation(value = "更新付款申请")
    ApiResult<List<Long>> updatePaymentApply(@RequestBody List<PurAccountCheckPaymentApplyUpdateRpcDTO> dtoList);
}
