package com.elitesland.pur.common.inter;

import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;
import java.util.Map;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/7/10 周四
 */
public interface PurPushRecordRepository {

    /**
     * 保存待重试的失败记录
     * <p>
     * docId和docNo不能同时为空
     *
     * @param inter
     * @param docId
     * @param docNo
     * @param errorMsg
     */
    void saveFailRecord(@NotNull PurInter inter, Long docId, String docNo, String errorMsg);

    /**
     * 保存推送记录
     *
     * @param inter
     * @param docNo
     * @param queryParams
     * @param reqBody
     * @param reqSuccess
     * @param reqTime
     * @param respBody
     * @param errorMsg
     */
    Long savePushRecord(PurInter inter, String docNo,
                        Map<String, String[]> queryParams, Object reqBody, boolean reqSuccess, LocalDateTime reqTime,
                        Object respBody, String errorMsg);
}
