package com.elitesland.pur.common.inter.bip;

import com.elitesland.pur.common.inter.PurInter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.function.Consumer;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/7/21 周一
 */
public interface PurBipPushClient {

    /**
     * 是否启用推送
     *
     * @return 是否启用推送
     */
    boolean isEnabled();

    /**
     * 推送
     *
     * @param inter   推送接口
     * @param docId   单据ID
     * @param docNo   单据编号
     * @param reqBody 推送内容
     * @return 推送结果
     */
    String push(@NotNull PurInter inter, @NotNull Long docId, @NotBlank String docNo, Object reqBody, Consumer<Long> pushRecordConsumer);

    /**
     * 格式化金额
     *
     * @param money
     * @return
     */
    default BigDecimal formatMoney(BigDecimal money, BipMoneyType moneyType) {
        if (money == null) {
            return null;
        }

        if (BipMoneyType.PRICE == moneyType) {
            // 单价4位
            return money.setScale(4, RoundingMode.HALF_UP);
        } else if (BipMoneyType.AMOUNT == moneyType) {
            // 金额2位
            return money.setScale(2, RoundingMode.HALF_UP);
        }

        return money;
    }
}
