package com.elitesland.pur.provider;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.pur.Application;
import com.elitesland.pur.dto.gr.PurGrRpcDTO;
import com.elitesland.pur.dto.rns.PurRnsRecvRpcSaveDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 采购退货出库单
 *
 * @author chaofeng.xia
 * @date 2023/9/25 16:56
 */
@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + PurRnsRecvProvider.PATH)
public interface PurRnsRecvProvider {
    String PATH = "/purRnsRecv";

    /**
     * 创建采购退货出库单RPC接口
     *
     * @param purRnsRecvRpcSaveDTO 退货出库单信息
     * @return 采购出库单id
     */
    @PostMapping("/createByCrossCompany")
    ApiResult<Long> createByCrossCompany(@RequestBody PurRnsRecvRpcSaveDTO purRnsRecvRpcSaveDTO);

    /**
     * 采购退货出库单确认出库
     *
     * @param purRnsRecvRpcSaveDTO 退货出库单信息
     * @return 采购退货出库单id
     */
    @PostMapping("/confirmRnsRecv")
    ApiResult<Long> confirmRnsRecv(@RequestBody PurRnsRecvRpcSaveDTO purRnsRecvRpcSaveDTO);

    @GetMapping("/findAllByRelateDoc2No")
    ApiResult<List<String>> findAllByRelate2DocNo(@RequestParam("relateDoc2No") String relateDoc2No, @RequestParam("relateDoc2Cls") String relateDoc2Cls);


    @GetMapping("/findAllByRelate2DocNoForIo")
    ApiResult<List<String>> findAllByRelate2DocNoForIo(@RequestParam("relateDoc2No") String relateDoc2No, @RequestParam("relateDoc2Cls") String relateDoc2Cls);

    @GetMapping("/findAllByRelate2DocNoForInterIo")
    ApiResult<List<String>> findAllByRelate2DocNoForInterIo(@RequestParam("relateDoc2No") String relateDoc2No, @RequestParam("relateDoc2Cls") String relateDoc2Cls);

    @GetMapping("/findByIdsForInvSup")
    ApiResult<PurGrRpcDTO> findByIdsForInvSup(@RequestParam("id") Long id);

}
