package com.elitesland.pur.dto.rns;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(description = "退货申请-退货出库单")
public class PurRnsRgrRpcDTO implements Serializable {

    private static final long serialVersionUID = -9066194839868175002L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("ID")
    private Long id;

    @ApiModelProperty("单号")
    private String docNo;

    private List<PurRnsRgrDRpcDTO> rnsRgrDRpcDTOS;

    @Data
    public static class PurRnsRgrDRpcDTO {
        private Long rgrDid;
        private Long rnsDid;
        private String lotNo;
        private String limit1;
        private LocalDateTime manuDate;
        private LocalDateTime expireDate;
    }
}