package com.tll.store.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.tll.store.Application;
import com.tll.store.rpc.dto.PagePgcStoreRpcDTO;
import com.tll.store.rpc.dto.InsertFranchiseeLawRpcDTO;
import com.tll.store.rpc.dto.StoreDetailQueryRpcDTO;
import com.tll.store.rpc.dto.StoreInfoListQueryRpcDTO;
import com.tll.store.rpc.vo.*;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author: daidemin
 * Date: 2024/12/24 09:16
 */
@FeignClient(name = Application.NAME, path = StoreInfoRpcService.URI)
@Validated
public interface StoreInfoRpcService {
    String URI = Application.URI_PREFIX + "/api/storeInfo";

    @GetMapping(value = "/getOperationStatusList")
    @ApiOperation(value = "获取操作状态列表")
    ApiResult<OperationStatusRpcVO> getOperationStatusList();

    @PostMapping(value = "/findStoreList")
    @ApiOperation(value = "获取门店列表")
    public ApiResult<PagingVO<StoreSimpleInfoRpcVO>> findStoreList(@RequestBody StoreInfoListQueryRpcDTO storeInfoListQueryDTO);


    @PostMapping(value = "/getStoreDetail")
    @ApiOperation(value = "获取门店详情")
    public ApiResult<StoreInfoRpcVO> getStoreDetail(@RequestBody @Validated StoreDetailQueryRpcDTO storeInfoListQueryDTO);


    @PostMapping(value = "/getStoreBasicDetail")
    @ApiOperation(value = "获取门店基础信息详情")
    public ApiResult<StoreBasicInfoRpcVO> getStoreBasicDetail(@RequestBody @Validated StoreDetailQueryRpcDTO storeInfoListQueryDTO);


    @PostMapping(value = "/getGoodsTransactionInfo")
    @ApiOperation(value = "获取收发货信息")
    public ApiResult<GoodsTransactionInfoRpcVO> getGoodsTransactionInfo(@RequestBody @Validated StoreDetailQueryRpcDTO storeInfoListQueryDTO);


    @PostMapping(value = "/getStoreManagerInfo")
    @ApiOperation(value = "获取门店负责人信息")
    public ApiResult<StoreManagerInfoRpcVO> getStoreManagerInfo(@RequestBody @Validated StoreDetailQueryRpcDTO storeInfoListQueryDTO);


    @PostMapping(value = "/getHousingInfo")
    @ApiOperation(value = "获取门店房源信息")
    public ApiResult<HousingInfoRpcVO> getHousingInfo(@RequestBody @Validated StoreDetailQueryRpcDTO storeInfoListQueryDTO);

    @PostMapping(value = "/getOtherInfo")
    @ApiOperation(value = "获取其他信息")
    public ApiResult<OtherInfoRpcVO> getOtherInfo(@RequestBody @Validated StoreDetailQueryRpcDTO storeInfoListQueryDTO);

    @PostMapping(value = "/insertFranchiseeLaw")
    @ApiOperation(value = "新增加盟商法人信息")
    ApiResult<InsertFranchiseeLawRpcVO> insertFranchiseeLaw(@RequestBody @Validated InsertFranchiseeLawRpcDTO insertFranchiseeLawRpcDTO);




    @PostMapping(value = "/pageStoreForPgc")
    @ApiOperation(value = "分页查询门店，pgc使用")
    public ApiResult<PagingVO<PgcStoreRpcVO>> pageStoreForPgc(@RequestBody @Validated PagePgcStoreRpcDTO pagePgcStoreRpcDTO);


}
