package com.tll.store.rpc.dto;

import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author: daidemin
 * Date: 2024/11/12 14:01
 */
@Data
@ApiModel("门店列表查询条件")
public class StoreInfoListQueryRpcDTO extends AbstractExportQueryParam {

    @ApiModelProperty("userId")
    private String userId;

    @ApiModelProperty(value = "登记人id")
    private String registrantId;

    @ApiModelProperty("门店名称/编码")
    private String storeDetail;

    @ApiModelProperty("省ID列表")
    private List<String> province;

    @ApiModelProperty("市ID列表")
    private List<String> city;

    @ApiModelProperty("区ID列表")
    private List<String> district;

    @ApiModelProperty("运营状态： 0：签约、1：营业中、2：短期闭店、3：空合同、4：到期解约、5：长期闭店、7：待装修、8：强制解约、9：其它解约 ")
    private Integer operationStatus;

    @ApiModelProperty("门店类型： 1：加盟店  0：直营店")
    private Integer storeType;

    @ApiModelProperty("法人")
    private String legalPerson;

    @ApiModelProperty("法人电话")
    private String legalPersonPhone;




}
