package com.tll.store.rpc.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;

/**
 * @author 齐燊登
 * @version 1.0
 * @date 2025/03/11
 */
@Data
@ApiModel("新增加盟商法人信息")
public class InsertFranchiseeLawRpcDTO implements Serializable {
    
    @ApiModelProperty(value = "预生成的门店编码（OA返回）")
    @NotBlank(message = "门店编码不能为空")
    private String preStoreCode;

    @ApiModelProperty(value = "统一社会信用代码或身份证号码(法人身份证号)")
    @NotBlank(message = "统一社会信用代码或身份证号码不能为空")
    private String unifiedSocialCreditCode;

    @ApiModelProperty(value = "身份证正面")
    @NotBlank(message = "身份证正面不能为空")
    private String identityCardNumber;

    @ApiModelProperty(value = "身份证反面")
    @NotBlank(message = "身份证反面不能为空")
    private String reverseIdentityCard;

    @ApiModelProperty(value = "加盟店的经营地址")
    private String franchiseAddress;

    @ApiModelProperty(value = "加盟方式")
    private String joiningMode;

    @ApiModelProperty(value = "合同结束日期")
    private Date contractEndDate;

    @ApiModelProperty(value = "乙方联系人姓名(法人姓名)")
    @NotBlank(message = "乙方联系人姓名不能为空")
    private String partyBContact;

    @ApiModelProperty(value = "乙方电子邮箱(法人电子邮箱)")
    private String partyBEmail;

    @ApiModelProperty(value = "乙方住址(法人住址)")
    private String partyBAddress;

    @ApiModelProperty(value = "乙方联系方式，如手机号码等(法人手机号)")
    @NotBlank(message = "乙方联系方式，如手机号码等不能为空")
    private String partyBPhone;

    @ApiModelProperty(value = "乙方的微信账号(法人微信账号)")
    private String partyBWechat;

}
