package com.tll.store.rpc.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * @author: daidemin
 * Date: 2024/11/12 19:03
 */
@Data
@ApiModel(value = "门店信息")
@NoArgsConstructor
@AllArgsConstructor
public class StoreInfoRpcVO implements Serializable {

    @ApiModelProperty(value = "门店简称")
    private String storeName;
    @ApiModelProperty(value = "门店编码")
    private String storeCode;
    @ApiModelProperty(value = "法人姓名")
    private String legalPerson;
    @ApiModelProperty(value = "法人电话")
    private String legalPersonPhone;
    @ApiModelProperty(value = "区域经理")
    private String areaManager;
    @ApiModelProperty(value = "省经理")
    private String provinceManager;
    @ApiModelProperty(value = "区域经理id")
    private String areaManagerId;
    @ApiModelProperty(value = "省经理id")
    private String provinceManagerId;
    @ApiModelProperty(value = "大区经理")
    private String regionManager;
    @ApiModelProperty(value = "大区经理Id")
    private String regionManagerId;
    @ApiModelProperty(value = "南北战区")
    private String warArea;
    @ApiModelProperty(value = "门店地址")
    private String storeAddress;
    @ApiModelProperty(value = "营业状态")
    private Integer operationStatus;

    @ApiModelProperty(value = "门店类型：1：加盟店  0：直营店")
    private Integer storeType;

    @ApiModelProperty(value = "直营店长")
    private String storeManager;
    @ApiModelProperty(value = "直营店经理")
    private String storeDirector;
    @ApiModelProperty(value = "直营店主管")
    private String storeSupervisor;

    @ApiModelProperty(value = "sap客户编码")
    private String sapCode;

    @ApiModelProperty(value = "u8c客商编码")
    private String u8cCustomerCode;

    @ApiModelProperty(value = "开业日期")
    private LocalDate openingDate;

    @ApiModelProperty(value = "门店经度")
    private Double longitude;

    @ApiModelProperty(value = "门店纬度")
    private Double latitude;

    @ApiModelProperty("活跃门店数")
    private Integer activeStoreNum;

}
