package com.tll.store.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.tll.store.Application;
import com.tll.store.rpc.dto.*;
import com.tll.store.rpc.vo.*;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;
import java.util.List;

/**
 * @author: daidemin
 * Date: 2024/12/24 09:16
 */
@FeignClient(name = Application.NAME, path = StoreInfoRpcService.URI)
@Validated
public interface StoreInfoRpcService {
    String URI = Application.URI_PREFIX + "/api/storeInfo";

    @GetMapping(value = "/getOperationStatusList")
    @ApiOperation(value = "获取操作状态列表")
    ApiResult<OperationStatusRpcVO> getOperationStatusList();

    @PostMapping(value = "/findStoreList")
    @ApiOperation(value = "获取门店列表")
    public ApiResult<PagingVO<StoreSimpleInfoRpcVO>> findStoreList(@RequestBody StoreInfoListQueryRpcDTO storeInfoListQueryDTO);


    @PostMapping(value = "/getStoreDetail")
    @ApiOperation(value = "获取门店详情")
    public ApiResult<StoreInfoRpcVO> getStoreDetail(@RequestBody @Validated StoreDetailQueryRpcDTO storeInfoListQueryDTO);


    @PostMapping(value = "/getStoreBasicDetail")
    @ApiOperation(value = "获取门店基础信息详情")
    public ApiResult<StoreBasicInfoRpcVO> getStoreBasicDetail(@RequestBody @Validated StoreDetailQueryRpcDTO storeInfoListQueryDTO);


    @PostMapping(value = "/getGoodsTransactionInfo")
    @ApiOperation(value = "获取收发货信息")
    public ApiResult<GoodsTransactionInfoRpcVO> getGoodsTransactionInfo(@RequestBody @Validated StoreDetailQueryRpcDTO storeInfoListQueryDTO);


    @PostMapping(value = "/getStoreManagerInfo")
    @ApiOperation(value = "获取门店负责人信息")
    public ApiResult<StoreManagerInfoRpcVO> getStoreManagerInfo(@RequestBody @Validated StoreDetailQueryRpcDTO storeInfoListQueryDTO);


    @PostMapping(value = "/getHousingInfo")
    @ApiOperation(value = "获取门店房源信息")
    public ApiResult<HousingInfoRpcVO> getHousingInfo(@RequestBody @Validated StoreDetailQueryRpcDTO storeInfoListQueryDTO);

    @PostMapping(value = "/getOtherInfo")
    @ApiOperation(value = "获取其他信息")
    public ApiResult<OtherInfoRpcVO> getOtherInfo(@RequestBody @Validated StoreDetailQueryRpcDTO storeInfoListQueryDTO);

    @PostMapping(value = "/insertFranchiseeLaw")
    @ApiOperation(value = "新增加盟商法人信息")
    ApiResult<InsertFranchiseeLawRpcVO> insertFranchiseeLaw(@RequestBody @Validated InsertFranchiseeLawRpcDTO insertFranchiseeLawRpcDTO);

    @PostMapping(value = "/findInspectStoreListEs")
    @ApiOperation(value = "巡检统计从ES获取门店")
    public ApiResult<List<UserStoreAggRpcVO>> findInspectStoreListEs(@RequestBody @Validated InspectStoreQueryRpcDTO queryRpcDTO);

    @PostMapping(value = "/pageStoreForPgc")
    @ApiOperation(value = "分页查询门店，pgc使用")
    public ApiResult<PagingVO<PgcStoreRpcVO>> pageStoreForPgc(@RequestBody @Validated PagePgcStoreRpcDTO pagePgcStoreRpcDTO);

    @PostMapping(value = "/findStoreListAll")
    @ApiOperation(value = "获取门店列表优化版本")
    public ApiResult<PagingVO<StoreSimpleInfoRpcVO>> findStoreListAll(@RequestBody @Validated StoreInfoListQueryRpcDTO queryRpcDTO);

    @PostMapping(value = "/findStorePageNew")
    @ApiOperation(value = "获取门店列表(新)")
    public ApiResult<PagingVO<StoreSimpleInfoRpcVO>> findStorePageNew(@RequestBody @Validated StoreInfoListQueryRpcDTO queryRpcDTO);

    @PostMapping(value = "/findStoreForInspectReport")
    @ApiOperation(value = "获取门店列表(巡检报告用)")
    public ApiResult<StoreForInspectReportRpcVO> findStoreForInspectReport(@RequestBody @Validated StoreInfoListQueryRpcDTO queryRpcDTO);

    @PostMapping(value = "/updateLocation")
    @ApiOperation(value = "修改门店经纬度")
    ApiResult<UnifiedReturnRpcVO> updateLocation(@RequestBody @Valid StoreLocationUpdateRpcDTO updateDTO);

    @PostMapping(value = "/storeBatchPage")
    @ApiOperation(value = "分页批量查询门店信息", notes = "性能限制：最大分页大小为1000（超过自动限制）")
    ApiResult<PagingVO<StoreRpcVO>> storeBatchPage(@RequestBody @Valid StoreBatchPageRpcDTO rpcDTO);

    @PostMapping(value = "/getStoreInfo")
    @ApiOperation(value = "获取门店基础信息")
    ApiResult<StoreDetailRpcVO> getStoreInfo(@RequestBody @Valid StoreCodeQueryRpcDTO rpcDTO);

}
