package com.tll.store.rpc.dto;

import com.elitescloud.cloudt.common.base.param.QueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;

/**
 * title: 查询人员门店排行榜
 * author: zzl
 * create: 2025-10-21 11:34:36
 *
 * @author zhangzhaolong
 */
@Data
@Accessors(chain = true)
public class UserStoreRankingRpcDTO extends QueryParam {

    @NotBlank(message = "用户ID不能为空")
    @ApiModelProperty("企微userId")
    private String userId;
    @NotBlank(message = "用户类型不能为空")
    @ApiModelProperty("用户类型(只有切换tab类型的时候会用到):根据配置文件动态配置")
    private String userType;
    private Integer pageSize;
}