package com.tll.store.rpc.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;

/**
 * 门店基础信息 RPC VO
 *
 * @author system
 * @date 2025-10-16
 */
@Data
@ApiModel("门店基础信息")
@NoArgsConstructor
@AllArgsConstructor
public class StoreDetailRpcVO implements Serializable {

    private static final long serialVersionUID = 2025101600000003L;

    @ApiModelProperty(value = "门店编号")
    private String storeCode;

    @ApiModelProperty(value = "商机编号")
    private String businessOpportunityId;

    @ApiModelProperty(value = "运营状态：0：签约、1：营业中、2：短期闭店、3：空合同、4：到期解约、5：长期闭店、7：待装修、8：强制解约、9：其它解约")
    private Integer operationStatus;

    @ApiModelProperty(value = "门店简称")
    private String storeName;

    @ApiModelProperty(value = "门店名称")
    private String storeDetailName;

    @ApiModelProperty(value = "门店类型：1：加盟店  0：直营店")
    private Integer storeType;

    @ApiModelProperty(value = "门店详细地址")
    private String storeAddress;

    @ApiModelProperty(value = "门店经度")
    private Double longitude;

    @ApiModelProperty(value = "门店纬度")
    private Double latitude;

    @ApiModelProperty(value = "地图标注")
    private String mapAnnotation;

    @ApiModelProperty(value = "开业日期")
    private LocalDate openingDate;

    @ApiModelProperty(value = "老店复签：是、否")
    private String oldStoreRenewal;

    @ApiModelProperty(value = "门店营业时间")
    private String storeBusinessHours;

    @ApiModelProperty(value = "解约日期")
    private LocalDate terminationDate;

    @ApiModelProperty(value = "是否已解约退款：是、否")
    private String contractTerminatedRefunded;

    @ApiModelProperty(value = "门店电话")
    private String storePhone;

    @ApiModelProperty(value = "U8C客商编码")
    private String u8cCustomerCode;

    @ApiModelProperty(value = "sap编码")
    private String sapId;

    @ApiModelProperty(value = "门头照图片")
    private String storePhoto;

    @ApiModelProperty(value = "登记人")
    private String registrant;

    @ApiModelProperty(value = "登记日期")
    private LocalDate registrationDate;

    @ApiModelProperty(value = "所属城市等级 : 一线、新一线、二线、三线、四线、无线")
    private String cityLevel;

    @ApiModelProperty(value = "所属行政区划 : 市区、县城、乡镇")
    private String administrativeDivision;

    @ApiModelProperty(value = "行政区")
    private String administrativeRegion;

    @ApiModelProperty(value = "所属商圈 : 商业街店、商场店（内部）、商场店（外部）、小吃街店、普通沿街商铺店、社区店、学校店")
    private String businessDistrict;

    @ApiModelProperty(value = "商圈等级 : S类商圈、A类商圈、B类商圈、C类商圈、5A风景区")
    private String businessDistrictLevel;

    @ApiModelProperty(value = "店铺营业额等级   : A/B/C/D/E")
    private String storeTurnoverLevel;

    @ApiModelProperty(value = "店铺盈亏等级    : A/B/C/D/E")
    private String storeProfitLossLevel;

    @ApiModelProperty(value = "周边情况")
    private String circumjacentSituation;

    @ApiModelProperty(value = "周边竞争分析")
    private String competitionAnalysis;

    @ApiModelProperty(value = "位置分析")
    private String locationAnalysis;

    @ApiModelProperty(value = "区域保护范围")
    private String territoryProtection;

    @ApiModelProperty(value = "是否为学校店铺：是、否")
    private String isSchoolStore;

    @ApiModelProperty(value = "是否属于代理区域：是、否")
    private String isAgentArea;

    @ApiModelProperty(value = "代理商编码")
    private String agentCode;

    @ApiModelProperty(value = "代理商姓名")
    private String agentName;

    @ApiModelProperty(value = "代理返点比例")
    private String agentRate;

    @ApiModelProperty(value = "代理级别")
    private String agentLevel;

    @ApiModelProperty(value = "省")
    private String province;

    @ApiModelProperty(value = "市")
    private String city;

    @ApiModelProperty(value = "区")
    private String district;

    @ApiModelProperty(value = "总面积（㎡）")
    private String totalArea;

    @ApiModelProperty(value = "长（m）")
    private String length;

    @ApiModelProperty(value = "宽（m）")
    private String width;

    @ApiModelProperty(value = "高（m）")
    private String height;

    @ApiModelProperty(value = "转角位")
    private String cornerPosition;

    @ApiModelProperty(value = "主干道")
    private String mainRoad;

    @ApiModelProperty(value = "街巷内")
    private String inTheStreetsAndAlleys;

    @ApiModelProperty(value = "其他店铺位置")
    private String otherStoreLocation;

    @ApiModelProperty(value = "三相电")
    private String threePhaseElectricity;

    @ApiModelProperty(value = "上下水")
    private String waterSupplyAndDrainage;

    @ApiModelProperty(value = "电信入户")
    private String telecomHomeEntry;

    @ApiModelProperty(value = "房租（万/年）")
    private String rent;

    @ApiModelProperty(value = "转让费")
    private String transferFee;

    @ApiModelProperty(value = "门店地址_其他")
    private String storeAddressOther;

    @ApiModelProperty(value = "是否补贴：是、否")
    private String subsidyRequired;

    @ApiModelProperty(value = "补贴金额（万）")
    private String subsidyAmount;

    @ApiModelProperty(value = "美团团购ID")
    private String meituanGroupBuyingId;

    @ApiModelProperty(value = "房源信息-审核人")
    private String housingInfoReviewer;

    @ApiModelProperty(value = "其他信息-审核人")
    private String otherInfoReviewer;

    @ApiModelProperty(value = "线上推广费已收取:已收取、未收取")
    private String onlinePromotionFeeReceived;

    @ApiModelProperty(value = "门店预售推广费是否已收取:已收取、未收取")
    private String storePresalePromotionFeeReceived;

    @ApiModelProperty(value = "需要封口机贴：需要、不需要")
    private String sealingMachineRequired;

    @ApiModelProperty(value = "需要二门头横幅：需要、不需要")
    private String bannerRequired;

    @ApiModelProperty(value = "需要大展架展画：是、否")
    private String displayRackRequired;

    @ApiModelProperty(value = "门头类型  ： A/B/C/D/E/无")
    private String doorheadType;

    @ApiModelProperty(value = "门头尺寸（m）")
    private String storeSize;

    @ApiModelProperty(value = "地毯尺寸")
    private String carpetSize;

    @ApiModelProperty(value = "门帘是否为标准尺寸（80*160）：是、否")
    private String standardCurtain;

    @ApiModelProperty(value = "礼包    : 套餐一/无")
    private String giftPack;

    @ApiModelProperty(value = "门店套餐")
    private String storePackage;

    @ApiModelProperty(value = "是否有无收银机：是、否")
    private String hasCashierMachine;

    @ApiModelProperty(value = "商户号")
    private String merchantNum;

    @ApiModelProperty(value = "收银机ID")
    private String cashRegisterId;

    @ApiModelProperty(value = "点餐屏信息")
    private String orderScreenInfo;

    @ApiModelProperty(value = "门店监控是否绑定海康云眸平台：是、否")
    private String hikvisionMonitoring;

    @ApiModelProperty(value = "门店信发标签    ： 普通区域、蚌埠区域、海南区域、提价区域")
    private String storeLabel;
    
    private String storeLabelName;
    
    private String storeLabelValue;

    @ApiModelProperty(value = "有报货折扣 1:是 2:否")
    private String haveGoodsReportedDiscount;
    
    @ApiModelProperty(value = "报货折扣")
    private String goodsReportedDiscount;
    
    @ApiModelProperty(value = "折扣有效期 1：长期有效 2：定期有效")
    private String discountValidityPeriod;
    
    @ApiModelProperty(value = "折扣有效期起")
    private LocalDate discountValidityPeriodStart;
    
    @ApiModelProperty(value = "折扣有效期止")
    private LocalDate discountValidityPeriodEnd;

    @ApiModelProperty(value = "报货限制")
    private String goodsReportingLimit;

    @ApiModelProperty(value = "报货负责人")
    private String merchandiser;

    @ApiModelProperty(value = "发货仓库")
    private String warehouse;

    @ApiModelProperty(value = "是否提价")
    private String priceIncrease;

    @ApiModelProperty(value = "冷链发货仓")
    private String coldChainWarehouse;

    @ApiModelProperty(value = "物流公司名称")
    private String logisticsCompanyName;

    @ApiModelProperty(value = "收货人")
    private String consignee;

    @ApiModelProperty(value = "收货人联系方式")
    private String consigneeContact;

    @ApiModelProperty(value = "收货人备用联系方式")
    private String consigneePhoneReserve;

    @ApiModelProperty(value = "收货地址省")
    private String deliveryAddressProvince;

    @ApiModelProperty(value = "收货地址省编码")
    private String deliveryAddressProvinceCode;

    @ApiModelProperty(value = "收货地址市")
    private String deliveryAddressCity;

    @ApiModelProperty(value = "收货地址市编码")
    private String deliveryAddressCityCode;

    @ApiModelProperty(value = "收货地址区")
    private String deliveryAddressDistrict;

    @ApiModelProperty(value = "收货地址区编码")
    private String deliveryAddressDistrictCode;

    @ApiModelProperty(value = "收货地址")
    private String deliveryAddress;

    @ApiModelProperty(value = "门面位置  1:转角位 2:主干道 3:街巷内 4:其他")
    private List<String> storeLocation;

    @ApiModelProperty(value = "基础设施  1:三相电 2:上下水 3:电信入户")
    private List<String> infrastructure;

    @ApiModelProperty("机器设备首付比例（如40表示40%）")
    private String storeInstallmentRatio;

    @ApiModelProperty("机器设备分期月数（如12表示12个月）")
    private String storeInstallmentMonths;

    @ApiModelProperty(value = "是否配茶饮机")
    private String storeHasTeaMachine;

    @ApiModelProperty(value = "是否配置1000磅制冰机")
    private String needIceMachine;

    @ApiModelProperty(value = "大区经理")
    private String regionManager;

    @ApiModelProperty(value = "大区经理id")
    private String regionManagerId;

    @ApiModelProperty(value = "区域经理")
    private String provinceManager;

    @ApiModelProperty(value = "区域经理id")
    private String provinceManagerId;

    @ApiModelProperty(value = "督导")
    private String areaManager;

    @ApiModelProperty(value = "督导id")
    private String areaManagerId;

    @ApiModelProperty(value = "法人姓名")
    private String legalPerson;

    @ApiModelProperty(value = "法人电话")
    private String legalPersonPhone;

    // ========== 基础信息缺失字段 ==========
    
    @ApiModelProperty(value = "小程序门店营业时间")
    private String storeBusinessHoursMin;

    @ApiModelProperty(value = "登记人Id")
    private String registrantId;

    @ApiModelProperty(value = "南北战区")
    private String warArea;

    @ApiModelProperty(value = "报货负责人Id")
    private String merchandiserId;

    @ApiModelProperty(value = "美团负责人Id")
    private String meituanManagerId;

    @ApiModelProperty(value = "饿了么负责人Id")
    private String elemeManagerId;

    @ApiModelProperty(value = "门店创建时间")
    private String createStoreTime;

    @ApiModelProperty(value = "招商负责人")
    private String investmentManager;

    @ApiModelProperty(value = "招商负责人Id")
    private String investmentManagerId;

    @ApiModelProperty(value = "拓展负责人")
    private String expansionManager;

    @ApiModelProperty(value = "拓展负责人Id")
    private String expansionManagerId;

    @ApiModelProperty(value = "设计负责人")
    private String designManager;

    @ApiModelProperty(value = "设计负责人Id")
    private String designManagerId;

    @ApiModelProperty(value = "装修负责人")
    private String decorationManager;

    @ApiModelProperty(value = "装修负责人Id")
    private String decorationManagerId;

    // ========== QBI表缺失字段 ==========
    
    @ApiModelProperty(value = "门店经理")
    private String storeManager;

    @ApiModelProperty(value = "门店主管")
    private String storeDirector;

    @ApiModelProperty(value = "门店督导")
    private String storeSupervisor;

    @ApiModelProperty(value = "美团经理")
    private String meituanManager;

    @ApiModelProperty(value = "饿了么经理")
    private String elemeManager;

    @ApiModelProperty(value = "设备经理")
    private String equipmentManager;

    @ApiModelProperty(value = "最后门店拜访")
    private String lastStoreVisit;

    @ApiModelProperty(value = "最后跟进")
    private String lastFollowUp;

    @ApiModelProperty(value = "银联商户号")
    private String unionpayMerchantNum;

    @ApiModelProperty(value = "银联终端号")
    private String unionpayTerminalNumber;

    // ========== QLP表缺失字段 ==========
    
    @ApiModelProperty(value = "法人身份证")
    private String legalIdentityCard;

    @ApiModelProperty(value = "联系地址")
    private String contactAddress;

    @ApiModelProperty(value = "加盟商学历")
    private String franchiseeEducation;

    @ApiModelProperty(value = "加盟商年龄")
    private String franchiseeAge;

    @ApiModelProperty(value = "加盟商合作")
    private String franchiseeCooperation;

    @ApiModelProperty(value = "加盟商经济状况")
    private String franchiseeEconomicCondition;

    @ApiModelProperty(value = "营业执照法人身份证正面已上传")
    private String businessLicenseLegalIdFrontUploaded;

    @ApiModelProperty(value = "营业执照法人身份证背面已上传")
    private String businessLicenseLegalIdBackUploaded;

    @ApiModelProperty(value = "营业执照法人身份证正面")
    private String businessLicenseLegalIdFront;

    @ApiModelProperty(value = "营业执照法人身份证背面")
    private String businessLicenseLegalIdBack;

    // ========== QBS表未查询字段 ==========
    
    @ApiModelProperty(value = "开通状态 0:未开通 1:已开通")
    private String openState;

    @ApiModelProperty(value = "开启渠道 1微信 2:支付宝 3:抖音")
    private String openChannels;

    @ApiModelProperty(value = "门店二维码")
    private String storeQuickResponseCode;

    @ApiModelProperty(value = "抖音授权手机号")
    private String douyinAuthorizedPhone;

    // ========== QHI表未查询字段 ==========
    
    @ApiModelProperty(value = "吧台尺寸（m）")
    private String barSize;

    @ApiModelProperty(value = "门店信发标签编码")
    private String storeLabelCode;

    @ApiModelProperty(value = "是否启动装修")
    private Boolean startDecoration;

    @ApiModelProperty(value = "不装修原因")
    private String notStartDecorationReason;

    @ApiModelProperty(value = "租赁合同列表")
    private String leaseContractList;

    @ApiModelProperty(value = "其他材料列表")
    private String otherMaterialList;

    @ApiModelProperty(value = "扩展审核人")
    private String expansionAuditor;

    @ApiModelProperty(value = "是否有客座区：是、否")
    private String hasSeatingArea;

    @ApiModelProperty(value = "是否落地窗：是、否")
    private String hasFloorWindow;

    @ApiModelProperty(value = "落地窗尺寸（高m）")
    private String floorWindowLength;

    @ApiModelProperty(value = "落地窗尺寸（宽m）")
    private String floorWindowWidth;

    // ========== QGT表未查询字段 ==========
    
    @ApiModelProperty(value = "货物补贴状态")
    private String goodsSubsidyStatus;

    // ========== QLP表未查询字段 ==========
    
    @ApiModelProperty(value = "员工id")
    private Long employeeId;

    @ApiModelProperty(value = "加盟商职业")
    private String franchiseeProfession;

    @ApiModelProperty(value = "性别 1：男 2：女")
    private String sex;

    @ApiModelProperty(value = "邮箱")
    private String contactMail;

    @ApiModelProperty(value = "国籍")
    private String nationality;

    @ApiModelProperty(value = "籍贯")
    private String nativePlace;

    @ApiModelProperty(value = "加盟商编号")
    private String franchiseeCode;

    @ApiModelProperty(value = "加盟状态 0:生效 1:失效")
    private Integer status;

    @ApiModelProperty(value = "代理状态 0:生效 1:失效")
    private Integer agentStatus;

    @ApiModelProperty(value = "累计加盟门店数")
    private Integer totalFranchiseeStoreNum;

    @ApiModelProperty(value = "活跃门店数")
    private Integer activeStoreNum;

    @ApiModelProperty(value = "代理门店数")
    private Integer totalAgentStoreNum;

    @ApiModelProperty(value = "代理自营门店数")
    private Integer selfManageStoresAmount;

    @ApiModelProperty(value = "代理非自营门店数")
    private Integer nonSelfManageStoresAmount;

    // ========== QFI表未查询字段 ==========
    
    @ApiModelProperty(value = "商家账户状态 0：未开户 1：正常 2：冻结 3:已注销")
    private String accountStatus;

    @ApiModelProperty(value = "总余额")
    private String totalBalance;

    @ApiModelProperty(value = "平台余额")
    private String platformBalance;

    @ApiModelProperty(value = "银行卡余额")
    private String bankBalance;

    @ApiModelProperty(value = "待缴款金额")
    private String debtAmount;

    @ApiModelProperty(value = "本店平台余额")
    private String balanceOfPlatform;

    @ApiModelProperty(value = "本店银行卡余额")
    private String bankBalanceOfStore;

    @ApiModelProperty(value = "银联账户号")
    private String unionPayAccount;

    @ApiModelProperty(value = "开户人姓名")
    private String accountHolder;

    @ApiModelProperty(value = "是否为主账户：是、否")
    private String isPrimaryAccount;

    @ApiModelProperty(value = "开户人身份证")
    private String accountHolderIdentityCard;

    @ApiModelProperty(value = "账户类型 1:个体工商户 2:企业 3:小微")
    private String accountType;

    @ApiModelProperty(value = "关联门店银行卡余额")
    private String relatedStoresBankBalance;

    @ApiModelProperty(value = "发票类型 1：普通发票 2：专用发票")
    private String invoiceType;

    @ApiModelProperty(value = "抬头类型 1：个人 2：单位")
    private String headerType;

    @ApiModelProperty(value = "开票名称")
    private String invoiceName;

    @ApiModelProperty(value = "单位税号")
    private String unitTyParagraph;

    @ApiModelProperty(value = "邮箱")
    private String mailbox;

    @ApiModelProperty(value = "税号")
    private String paragraph;

    @ApiModelProperty(value = "持卡人姓名")
    private String cardholderName;
}

