package com.tll.store.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.tll.store.Application;
import com.tll.store.rpc.dto.GoodsTransactionDTO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(name = Application.NAME, path = GoodsTransactionRpcService.URI)
@Validated
public interface GoodsTransactionRpcService {
    String URI = Application.URI_PREFIX + "/goods/transaction";

    @PostMapping(value = "/edit")
    @ApiOperation(value = "更新报货折扣")
    ApiResult<Long> edit(@RequestBody GoodsTransactionDTO goodsTransactionDTO);
}
