package com.tll.store.rpc.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author: Unicorn
 * @Description: 更新门店参数信息
 * @Date: 2025/5/12 14:01
 * @Version: 1.0
 */
@Data
public class CreateByContractRPCDto implements Serializable {
    private static final long serialVersionUID = 1784639232425046270L;


    @NotBlank(message = "签约编号不能为空")
    @ApiModelProperty(value = "签约编号")
    private String formalAgreementNo;

    @NotBlank(message = "门店编号不能为空")
    @ApiModelProperty(value = "门店编号")
    private String storeCode;


    @NotBlank(message = "法人姓名不能为空")
    @ApiModelProperty(value = "法人")
    private String legalPerson;

    @NotBlank(message = "法人电话不能为空")
    @ApiModelProperty(value = "法人电话")
    private String legalPersonPhone;

    @NotBlank(message = "法人身份证不能为空")
    @ApiModelProperty(value = "法人身份证号码")
    private String legalIdentityCard;

    @NotBlank(message = "法人身份证正面不能为空")
    @ApiModelProperty(value = "法人身份证正面")
    private String businessLicenseLegalIdFront;

    @NotBlank(message = "法人身份证反面不能为空")
    @ApiModelProperty(value = "法人身份证反面")
    private String businessLicenseLegalIdBack;

    @NotBlank(message = "房源编号不能为空")
    @ApiModelProperty(value = "房源编号")
    private String houseResourceNo;


    @NotNull(message = "房源经度不能为空")
    @ApiModelProperty(value = "房源经度")
    private BigDecimal houseResourceLnt;


    @NotNull(message = "房源纬度不能为空")
    @ApiModelProperty(value = "房源纬度")
    private BigDecimal houseResourceLat;


    @NotBlank(message = "门店详细地址不能为空")
    @ApiModelProperty(value = "门店详细地址")
    private String storeDetailAddress;

    @ApiModelProperty(value = "房源地图标注")

    private String mapAnnotation;

    @ApiModelProperty(value = "区域保护范围不能为空")
    @NotBlank(message = "区域保护范围不能为空")
    private String regionalProtectionScope;


    @ApiModelProperty(value = "门店简称")
    @NotBlank(message = "门店简称不能为空")
    private String storeName;

    @ApiModelProperty(value = "门店详细名称")
    @NotBlank(message = "门店详细名称名称不能为空")
    private String storeDetailName;

    /**
     * 营业额等级
     */
    @ApiModelProperty(value = "营业额等级")
    @NotBlank(message = "营业额等级不能为空")
    private String revenueLevel;

    /**
     * 是否老店复签
     */
    @ApiModelProperty(value = "是否老店复签")
    @NotNull(message = "是否老店复签不能为空")
    private Boolean oldStoreReSign;


    /**
     * 信发标签
     */
    @ApiModelProperty(value = "信发标签")
    @NotBlank(message = "信发标签不能为空")
    private String sendLabel;


    @ApiModelProperty(value = "是否补贴房源")
    @NotNull(message = "是否补贴房源不能为空")
    private Boolean subsidyHouseResource;


    @ApiModelProperty(value = "货补合同编号")
    private String goodsReplenishmentContractNo;
    /**
     * 是否补贴房源”=是时必填
     */
    @ApiModelProperty(value = "补贴类型   GOODS_DISCOUNT(1, \"报货折扣\"),\n" +
            "\n" +
            "    HOUSE_DISCOUNT(2, \"房补\");")
    private Integer subsidyType;


    /**
     * 补贴类型”=报货折扣时必填
     */
    @ApiModelProperty(value = "报货折扣")
    private String subsidyRate;


    /**
     * “补贴类型”=报货折扣时必填
     */
    @ApiModelProperty(value = "补贴金额")
    private String subsidyAmount;


    @ApiModelProperty(value = "收货人姓名")
    @NotBlank(message = "收货人姓名不能为空")
    private String receiverName;

    @ApiModelProperty(value = "收货人电话")
    @NotBlank(message = "收货人电话不能为空")
    private String receiverPhone;

    @ApiModelProperty(value = "收货人备用电话")

    private String backUpReceiverPhone;


    @ApiModelProperty(value = "收货地址省")
    @NotBlank(message = "收货地址省不能为空")
    private String receiveProvince;

    @ApiModelProperty(value = "收货地址省code")
    @NotBlank(message = "收货地址省code不能为空")
    private String receiveProvinceCode;

    @ApiModelProperty(value = "收货地址城市")
    @NotBlank(message = "收货地址城市不能为空")
    private String receiveCity;

    @ApiModelProperty(value = "收货地址城市code")
    @NotBlank(message = "收货地址城市code不能为空")
    private String receiveCityCode;

    @ApiModelProperty(value = "收货地址区名")
    @NotBlank(message = "收货地址区名不能为空")
    private String receiveRegion;

    @ApiModelProperty(value = "收货地址区code")
    @NotBlank(message = "收货地址区code不能为空")
    private String receiveRegionCode;


    @ApiModelProperty(value = "收货地址")
    @NotBlank
    @Length(min = 1, max = 100)
    private String receiveDetailAddress;


    @ApiModelProperty(value = "套餐")
    @NotBlank(message = "套餐不能为空")
    private String bundle;


    @ApiModelProperty(value = "是否代理区域")
    @NotNull(message = "是否代理不能为空")

    private Boolean agent;

    @ApiModelProperty(value = "代理商姓名")
    private String agentName;


    @ApiModelProperty(value = "代理商编码")
    private String agentCode;

//    @ApiModelProperty(value = "代理商等级")
//    private String agentLevel;

    /**
     * 代理商返点比例
     */
    @ApiModelProperty(value = "代理商返点比例")

    private String agentRate;

    @ApiModelProperty(value = "代理商身份证号")
    private String agentIdCard;


    @NotBlank(message = "房源地址不能为空")
    @ApiModelProperty(value = "房源地址")
    private String houseResourceDetailAddress;

    @ApiModelProperty(value = "房源省")
    private String houseResourceProvince;

    @ApiModelProperty(value = "房源省code")

    private String houseResourceProvinceCode;

    @ApiModelProperty(value = "房源城市")

    private String houseResourceCity;

    @ApiModelProperty(value = "房源城市code")

    private String houseResourceCityCode;

    @ApiModelProperty(value = "房源区")

    private String houseResourceRegion;

    @ApiModelProperty(value = "房源区code")
    private String houseResourceRegionCode;

    @NotBlank(message = "拓展审核人不能为空")
    @ApiModelProperty(value = "拓展审核人")
    private String expansionAuditor;



    @ApiModelProperty(value = "房源长")
    private String houseResourceLength;
    @ApiModelProperty(value = "房源宽")

    private String houseResourceWidth;


    @ApiModelProperty(value = "房源高")
    private String houseResourceHeight;


    @ApiModelProperty(value = "房源面积")
    private String houseResourceArea;

    @ApiModelProperty(value = "转角位   0：没有 1：有',")
    private String cornerPosition;

    @ApiModelProperty(value = "主干道   0：没有 1：有',")
    private String mainRoad;

    @ApiModelProperty(value = "街巷内   0：没有 1：有")
    private String inTheStreetsAndAlleys;


    @ApiModelProperty(value = "三相电   0：没有 1：有")
    private String threePhaseElectricity;

    @ApiModelProperty(value = "上下水   0：没有 1：有")
    private String waterSupplyAndDrainage;

    @ApiModelProperty(value = "电信入户   0：没有 1：有")
    private String telecomHomeEntry;


    @ApiModelProperty(value = "房租")
    private String houseResourceRent;

    @ApiModelProperty(value = "转让费")
    private String transferFee;


    @ApiModelProperty(value = "租赁合同列表")
    private String LeaseContractList;


    @ApiModelProperty(value = "其他材料列表")
    private String otherMaterialList;

    @ApiModelProperty(value = "是否启动装修")
    @NotNull(message = "是否启动装修不能为空")
    private Boolean startDecoration;

    @Length(max = 300)
    @ApiModelProperty(value = "不启动装修原因")
    private String notStartDecorationReason;

    /**
     * 登记人姓名
     */
    @ApiModelProperty(value = "登记人姓名")
    private String registrant;

    /**
     * 登记人id
     */
    @ApiModelProperty(value = "登记人id")
    private String registrantId;

    /**
     * 分期比例
     */
    @ApiModelProperty(value = "分期比例")
    private String storeInstallmentRatio;

    /**
     * 分期月数
     */
    @ApiModelProperty(value = "分期月数")
    private String storeInstallmentMonths;

    /**
     * 是否配茶饮机
     */
    @ApiModelProperty(value = "是否配茶饮机")
    private String storeHasTeaMachine;

    /**
     * 是否配置1000磅制冰机
     */
    @ApiModelProperty(value = "是否配置1000磅制冰机")
    private String needIceMachine;

    /**
     * SAP编码
     */
    @ApiModelProperty(value = "SAP编码")
    private String sapNumber;

    @ApiModelProperty(value = "招商负责人Id")
    private String investmentManagerId;

    @ApiModelProperty(value = "拓展负责人Id")
    private String expansionManagerId;
}
